/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client;

import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.context.annotation.EachProperty;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.http.client.HttpClientConfiguration;
import io.micronaut.http.context.ClientContextPathProvider;
import io.micronaut.http.ssl.AbstractClientSslConfiguration;
import io.micronaut.http.ssl.SslConfiguration;
import io.micronaut.runtime.ApplicationConfiguration;
import jakarta.inject.Inject;
import java.net.URI;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.jspecify.annotations.Nullable;

@EachProperty(value="micronaut.http.services")
public class ServiceHttpClientConfiguration
extends HttpClientConfiguration
implements ClientContextPathProvider {
    public static final String PREFIX = "micronaut.http.services";
    public static final String DEFAULT_HEALTHCHECKURI = "/health";
    public static final boolean DEFAULT_HEALTHCHECK = false;
    public static final long DEFAULT_HEALTHCHECKINTERVAL_SECONDS = 30L;
    private final String serviceId;
    private final ServiceConnectionPoolConfiguration connectionPoolConfiguration;
    private final ServiceWebSocketCompressionConfiguration webSocketCompressionConfiguration;
    private final ServiceHttp2ClientConfiguration http2Configuration;
    private List<URI> urls = Collections.emptyList();
    private String healthCheckUri = "/health";
    private boolean healthCheck = false;
    private Duration healthCheckInterval = Duration.ofSeconds(30L);
    private String path;

    public ServiceHttpClientConfiguration(@Parameter String serviceId, @Nullable ServiceConnectionPoolConfiguration connectionPoolConfiguration, @Nullable ServiceSslClientConfiguration sslConfiguration, ApplicationConfiguration applicationConfiguration) {
        super(applicationConfiguration);
        this.serviceId = serviceId;
        if (sslConfiguration != null) {
            this.setSslConfiguration((SslConfiguration)sslConfiguration);
        }
        this.connectionPoolConfiguration = connectionPoolConfiguration != null ? connectionPoolConfiguration : new ServiceConnectionPoolConfiguration();
        this.webSocketCompressionConfiguration = new ServiceWebSocketCompressionConfiguration();
        this.http2Configuration = new ServiceHttp2ClientConfiguration();
    }

    @Deprecated(since="4.3.0")
    public ServiceHttpClientConfiguration(@Parameter String serviceId, @Nullable ServiceConnectionPoolConfiguration connectionPoolConfiguration, @Nullable ServiceSslClientConfiguration sslConfiguration, HttpClientConfiguration defaultHttpClientConfiguration) {
        this(serviceId, connectionPoolConfiguration, new ServiceWebSocketCompressionConfiguration(), sslConfiguration, defaultHttpClientConfiguration);
    }

    @Deprecated(since="4.6.0")
    public ServiceHttpClientConfiguration(@Parameter String serviceId, @Nullable ServiceConnectionPoolConfiguration connectionPoolConfiguration, @Nullable ServiceWebSocketCompressionConfiguration webSocketCompressionConfiguration, @Nullable ServiceSslClientConfiguration sslConfiguration, HttpClientConfiguration defaultHttpClientConfiguration) {
        this(serviceId, connectionPoolConfiguration, webSocketCompressionConfiguration, new ServiceHttp2ClientConfiguration(), sslConfiguration, defaultHttpClientConfiguration);
    }

    @Inject
    public ServiceHttpClientConfiguration(@Parameter String serviceId, @Nullable ServiceConnectionPoolConfiguration connectionPoolConfiguration, @Nullable ServiceWebSocketCompressionConfiguration webSocketCompressionConfiguration, @Nullable ServiceHttp2ClientConfiguration http2Configuration, @Nullable ServiceSslClientConfiguration sslConfiguration, HttpClientConfiguration defaultHttpClientConfiguration) {
        super(defaultHttpClientConfiguration);
        this.serviceId = serviceId;
        if (sslConfiguration != null) {
            this.setSslConfiguration((SslConfiguration)sslConfiguration);
        }
        this.connectionPoolConfiguration = Objects.requireNonNullElseGet(connectionPoolConfiguration, ServiceConnectionPoolConfiguration::new);
        this.webSocketCompressionConfiguration = Objects.requireNonNullElseGet(webSocketCompressionConfiguration, ServiceWebSocketCompressionConfiguration::new);
        this.http2Configuration = Objects.requireNonNullElseGet(http2Configuration, ServiceHttp2ClientConfiguration::new);
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public List<URI> getUrls() {
        return this.urls;
    }

    public void setUrls(List<URI> urls) {
        if (CollectionUtils.isNotEmpty(urls)) {
            this.urls = urls;
        }
    }

    public void setUrl(URI url) {
        if (url != null) {
            this.urls = Collections.singletonList(url);
        }
    }

    public String getHealthCheckUri() {
        return this.healthCheckUri;
    }

    public void setHealthCheckUri(String healthCheckUri) {
        this.healthCheckUri = healthCheckUri;
    }

    public boolean isHealthCheck() {
        return this.healthCheck;
    }

    public void setHealthCheck(boolean healthCheck) {
        this.healthCheck = healthCheck;
    }

    public Optional<String> getPath() {
        return Optional.ofNullable(this.path);
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Optional<String> getContextPath() {
        return this.getPath();
    }

    public Duration getHealthCheckInterval() {
        return this.healthCheckInterval;
    }

    public void setHealthCheckInterval(Duration healthCheckInterval) {
        if (healthCheckInterval != null) {
            this.healthCheckInterval = healthCheckInterval;
        }
    }

    @Override
    public HttpClientConfiguration.ConnectionPoolConfiguration getConnectionPoolConfiguration() {
        return this.connectionPoolConfiguration;
    }

    @Override
    public HttpClientConfiguration.WebSocketCompressionConfiguration getWebSocketCompressionConfiguration() {
        return this.webSocketCompressionConfiguration;
    }

    @Override
    public ServiceHttp2ClientConfiguration getHttp2Configuration() {
        return this.http2Configuration;
    }

    @ConfigurationProperties(value="pool")
    public static class ServiceConnectionPoolConfiguration
    extends HttpClientConfiguration.ConnectionPoolConfiguration {
    }

    @ConfigurationProperties(value="ws.compression")
    public static class ServiceWebSocketCompressionConfiguration
    extends HttpClientConfiguration.WebSocketCompressionConfiguration {
    }

    @ConfigurationProperties(value="ws.compression")
    public static class ServiceHttp2ClientConfiguration
    extends HttpClientConfiguration.Http2ClientConfiguration {
    }

    @ConfigurationProperties(value="ssl")
    public static class ServiceSslClientConfiguration
    extends AbstractClientSslConfiguration {
        void setKey(@Nullable DefaultKeyConfiguration keyConfiguration) {
            if (keyConfiguration != null) {
                super.setKey((SslConfiguration.KeyConfiguration)keyConfiguration);
            }
        }

        void setKeyStore(@Nullable DefaultKeyStoreConfiguration keyStoreConfiguration) {
            if (keyStoreConfiguration != null) {
                super.setKeyStore((SslConfiguration.KeyStoreConfiguration)keyStoreConfiguration);
            }
        }

        void setTrustStore(@Nullable DefaultTrustStoreConfiguration trustStore) {
            if (trustStore != null) {
                super.setTrustStore((SslConfiguration.TrustStoreConfiguration)trustStore);
            }
        }

        @ConfigurationProperties(value="trust-store")
        public static class DefaultTrustStoreConfiguration
        extends SslConfiguration.TrustStoreConfiguration {
        }

        @ConfigurationProperties(value="key-store")
        public static class DefaultKeyStoreConfiguration
        extends SslConfiguration.KeyStoreConfiguration {
        }

        @ConfigurationProperties(value="key")
        public static class DefaultKeyConfiguration
        extends SslConfiguration.KeyConfiguration {
        }
    }
}

