/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client;

import io.micronaut.http.HttpRequest;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.client.HttpClientConfiguration;
import io.micronaut.http.client.ProxyHttpClientFactoryResolver;
import io.micronaut.http.client.ProxyRequestOptions;
import java.net.URL;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.reactivestreams.Publisher;

public interface ProxyHttpClient {
    public Publisher<MutableHttpResponse<?>> proxy(@NonNull HttpRequest<?> var1);

    default public Publisher<MutableHttpResponse<?>> proxy(@NonNull HttpRequest<?> request, @NonNull ProxyRequestOptions options) {
        if (options.equals(ProxyRequestOptions.getDefault())) {
            return this.proxy(request);
        }
        throw new UnsupportedOperationException("Not implemented");
    }

    public static ProxyHttpClient create(@Nullable URL url) {
        return ProxyHttpClientFactoryResolver.getFactory().createProxyClient(url);
    }

    public static ProxyHttpClient create(@Nullable URL url, @NonNull HttpClientConfiguration configuration) {
        return ProxyHttpClientFactoryResolver.getFactory().createProxyClient(url, configuration);
    }
}

