/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client;

import io.micronaut.context.LifeCycle;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.client.BlockingHttpClient;
import io.micronaut.http.client.HttpClientConfiguration;
import io.micronaut.http.client.HttpClientFactoryResolver;
import io.micronaut.http.client.exceptions.HttpClientResponseException;
import io.micronaut.http.hateoas.JsonError;
import java.io.Closeable;
import java.net.URL;
import java.util.Optional;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

public interface HttpClient
extends Closeable,
LifeCycle<HttpClient> {
    public static final Argument<JsonError> DEFAULT_ERROR_TYPE = Argument.of(JsonError.class);

    public BlockingHttpClient toBlocking();

    public <I, O, E> Publisher<HttpResponse<O>> exchange(@NonNull HttpRequest<I> var1, @NonNull Argument<O> var2, @NonNull Argument<E> var3);

    default public <I, O> Publisher<HttpResponse<O>> exchange(@NonNull HttpRequest<I> request, @NonNull Argument<O> bodyType) {
        return this.exchange(request, bodyType, DEFAULT_ERROR_TYPE);
    }

    default public <I> Publisher<HttpResponse<ByteBuffer>> exchange(@NonNull HttpRequest<I> request) {
        return this.exchange(request, ByteBuffer.class);
    }

    default public Publisher<HttpResponse<ByteBuffer>> exchange(@NonNull String uri) {
        return this.exchange((HttpRequest)HttpRequest.GET((String)uri), (Class)ByteBuffer.class);
    }

    default public <O> Publisher<HttpResponse<O>> exchange(@NonNull String uri, @NonNull Class<O> bodyType) {
        return this.exchange((HttpRequest)HttpRequest.GET((String)uri), (Argument<O>)Argument.of(bodyType));
    }

    default public <I, O> Publisher<HttpResponse<O>> exchange(@NonNull HttpRequest<I> request, @NonNull Class<O> bodyType) {
        return this.exchange(request, Argument.of(bodyType));
    }

    default public <I, O, E> Publisher<O> retrieve(@NonNull HttpRequest<I> request, @NonNull Argument<O> bodyType, @NonNull Argument<E> errorType) {
        Flux exchange = Flux.from(this.exchange(request, bodyType, errorType));
        if (bodyType.getType() == Void.TYPE) {
            return exchange.ignoreElements();
        }
        return exchange.map(response -> {
            if (bodyType.getType() == HttpStatus.class) {
                return response.getStatus();
            }
            Optional body = response.getBody();
            if (!body.isPresent() && response.getBody(byte[].class).isPresent()) {
                throw new HttpClientResponseException("Failed to decode the body for the given content type [%s]".formatted(response.getContentType().orElse(null)), (HttpResponse<?>)response);
            }
            return body.orElseThrow(() -> new HttpClientResponseException("Empty body", (HttpResponse<?>)response));
        });
    }

    default public <I, O> Publisher<O> retrieve(@NonNull HttpRequest<I> request, @NonNull Argument<O> bodyType) {
        return this.retrieve(request, bodyType, DEFAULT_ERROR_TYPE);
    }

    default public <I, O> Publisher<O> retrieve(@NonNull HttpRequest<I> request, @NonNull Class<O> bodyType) {
        return this.retrieve(request, Argument.of(bodyType));
    }

    default public <I> Publisher<String> retrieve(@NonNull HttpRequest<I> request) {
        return this.retrieve(request, String.class);
    }

    default public Publisher<String> retrieve(@NonNull String uri) {
        return this.retrieve((HttpRequest)HttpRequest.GET((String)uri), (Class)String.class);
    }

    default public HttpClient refresh() {
        this.stop();
        return (HttpClient)this.start();
    }

    public static HttpClient create(@Nullable URL url) {
        return HttpClientFactoryResolver.getFactory().createClient(url);
    }

    public static HttpClient create(@Nullable URL url, @NonNull HttpClientConfiguration configuration) {
        return HttpClientFactoryResolver.getFactory().createClient(url, configuration);
    }
}

