/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.HttpVersion;
import io.micronaut.http.client.HttpClientConfiguration;
import io.micronaut.http.client.annotation.Client;
import java.util.Arrays;
import java.util.Objects;

public final class HttpVersionSelection {
    public static final String ALPN_HTTP_1 = "http/1.1";
    public static final String ALPN_HTTP_2 = "h2";
    public static final String ALPN_HTTP_3 = "h3";
    private static final HttpVersionSelection LEGACY_1 = new HttpVersionSelection(PlaintextMode.HTTP_1, false, new String[]{"http/1.1"}, false);
    private static final HttpVersionSelection LEGACY_2 = new HttpVersionSelection(PlaintextMode.H2C, true, new String[]{"http/1.1", "h2"}, true);
    private static final HttpVersionSelection WEBSOCKET_1 = new HttpVersionSelection(PlaintextMode.HTTP_1, true, new String[]{"http/1.1"}, false);
    private final PlaintextMode plaintextMode;
    private final boolean alpn;
    private final String[] alpnSupportedProtocols;
    private final boolean http2CipherSuites;
    private final boolean http3;

    private HttpVersionSelection(@NonNull PlaintextMode plaintextMode, boolean alpn, @NonNull String[] alpnSupportedProtocols, boolean http2CipherSuites) {
        this.plaintextMode = plaintextMode;
        this.alpn = alpn;
        this.alpnSupportedProtocols = alpnSupportedProtocols;
        this.http2CipherSuites = http2CipherSuites;
        this.http3 = Arrays.asList(alpnSupportedProtocols).contains(ALPN_HTTP_3);
        if (this.http3 && alpnSupportedProtocols.length != 1) {
            throw new IllegalArgumentException("When using HTTP 3, h3 must be the only ALPN protocol");
        }
    }

    @NonNull
    public static HttpVersionSelection forLegacyVersion(@NonNull HttpVersion httpVersion) {
        switch (httpVersion) {
            case HTTP_1_0: 
            case HTTP_1_1: {
                return LEGACY_1;
            }
            case HTTP_2_0: {
                return LEGACY_2;
            }
        }
        throw new IllegalArgumentException("HTTP version " + String.valueOf(httpVersion) + " not supported here");
    }

    @NonNull
    public static HttpVersionSelection forWebsocket() {
        return WEBSOCKET_1;
    }

    public static HttpVersionSelection forClientConfiguration(HttpClientConfiguration clientConfiguration) {
        HttpVersion legacyHttpVersion = clientConfiguration.getHttpVersion();
        if (legacyHttpVersion != null) {
            return HttpVersionSelection.forLegacyVersion(legacyHttpVersion);
        }
        String[] alpnModes = clientConfiguration.getAlpnModes().toArray(StringUtils.EMPTY_STRING_ARRAY);
        return new HttpVersionSelection(clientConfiguration.getPlaintextMode(), true, alpnModes, Arrays.asList(alpnModes).contains(ALPN_HTTP_2));
    }

    @Internal
    @Nullable
    public static HttpVersionSelection forClientAnnotation(AnnotationMetadata metadata) {
        HttpVersion legacyHttpVersion = metadata.enumValue(Client.class, "httpVersion", HttpVersion.class).orElse(null);
        if (legacyHttpVersion != null) {
            return HttpVersionSelection.forLegacyVersion(legacyHttpVersion);
        }
        String[] alpnModes = metadata.stringValues(Client.class, "alpnModes");
        PlaintextMode plaintextMode = metadata.enumValue(Client.class, "plaintextMode", PlaintextMode.class).orElse(null);
        if (alpnModes.length == 0 && plaintextMode == null) {
            return null;
        }
        if (alpnModes.length == 0) {
            alpnModes = new String[]{ALPN_HTTP_2, ALPN_HTTP_1};
        }
        if (plaintextMode == null) {
            plaintextMode = PlaintextMode.HTTP_1;
        }
        return new HttpVersionSelection(plaintextMode, true, alpnModes, Arrays.asList(alpnModes).contains(ALPN_HTTP_2));
    }

    @Internal
    public PlaintextMode getPlaintextMode() {
        return this.plaintextMode;
    }

    @Internal
    public String[] getAlpnSupportedProtocols() {
        return this.alpnSupportedProtocols;
    }

    @Internal
    public boolean isAlpn() {
        return this.alpn;
    }

    @Internal
    public boolean isHttp2CipherSuites() {
        return this.http2CipherSuites;
    }

    @Internal
    public boolean isHttp3() {
        return this.http3;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpVersionSelection that = (HttpVersionSelection)o;
        return this.alpn == that.alpn && this.http2CipherSuites == that.http2CipherSuites && this.http3 == that.http3 && this.plaintextMode == that.plaintextMode && Arrays.equals(this.alpnSupportedProtocols, that.alpnSupportedProtocols);
    }

    public int hashCode() {
        int result = Objects.hash(new Object[]{this.plaintextMode, this.alpn, this.http2CipherSuites, this.http3});
        result = 31 * result + Arrays.hashCode(this.alpnSupportedProtocols);
        return result;
    }

    public static enum PlaintextMode {
        HTTP_1,
        H2C;

    }
}

