/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.loadbalance;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.discovery.ServiceInstance;
import io.micronaut.http.client.LoadBalancer;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Optional;
import org.reactivestreams.Publisher;

public class FixedLoadBalancer
implements LoadBalancer {
    private final Publisher<ServiceInstance> publisher;
    private final ServiceInstance serviceInstance;
    private final URI uri;

    @Deprecated
    public FixedLoadBalancer(URL url) {
        this(FixedLoadBalancer.toUriUnchecked(url));
    }

    public FixedLoadBalancer(URI uri) {
        this.uri = uri;
        this.serviceInstance = ServiceInstance.of((String)uri.getHost(), (URI)uri);
        this.publisher = Publishers.just((Object)this.serviceInstance);
    }

    @Override
    public Publisher<ServiceInstance> select(@Nullable Object discriminator) {
        return this.publisher;
    }

    @Deprecated
    public URL getUrl() {
        try {
            return this.uri.toURL();
        }
        catch (MalformedURLException e) {
            throw new UncheckedIOException(e);
        }
    }

    public URI getUri() {
        return this.uri;
    }

    @Internal
    public ServiceInstance getServiceInstance() {
        return this.serviceInstance;
    }

    @Override
    public Optional<String> getContextPath() {
        return Optional.ofNullable(this.getUri().getPath());
    }

    private static URI toUriUnchecked(URL url) {
        try {
            return url.toURI();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Illegal URI", e);
        }
    }
}

