/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.function.client.aws;

import com.amazonaws.services.lambda.AWSLambdaAsync;
import com.amazonaws.services.lambda.model.InvokeRequest;
import com.amazonaws.services.lambda.model.InvokeResult;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.io.buffer.ByteBufferFactory;
import io.micronaut.core.type.Argument;
import io.micronaut.function.client.FunctionDefinition;
import io.micronaut.function.client.FunctionInvoker;
import io.micronaut.function.client.FunctionInvokerChooser;
import io.micronaut.function.client.aws.AWSInvokeRequestDefinition;
import io.micronaut.function.client.exceptions.FunctionExecutionException;
import io.micronaut.jackson.codec.JsonMediaTypeCodec;
import io.reactivex.Flowable;
import io.reactivex.Scheduler;
import io.reactivex.schedulers.Schedulers;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.inject.Named;
import javax.inject.Singleton;

@Requires(beans={AWSLambdaAsync.class})
@Singleton
public class AWSLambdaFunctionExecutor<I, O>
implements FunctionInvoker<I, O>,
FunctionInvokerChooser {
    private static final int STATUS_CODE_ERROR = 300;
    private final AWSLambdaAsync asyncClient;
    private final ByteBufferFactory byteBufferFactory;
    private final JsonMediaTypeCodec jsonMediaTypeCodec;
    private final ExecutorService ioExecutor;

    protected AWSLambdaFunctionExecutor(AWSLambdaAsync asyncClient, ByteBufferFactory byteBufferFactory, JsonMediaTypeCodec jsonMediaTypeCodec, @Named(value="io") ExecutorService ioExecutor) {
        this.asyncClient = asyncClient;
        this.byteBufferFactory = byteBufferFactory;
        this.jsonMediaTypeCodec = jsonMediaTypeCodec;
        this.ioExecutor = ioExecutor;
    }

    @Override
    public O invoke(FunctionDefinition definition, I input, Argument<O> outputType) {
        if (!(definition instanceof AWSInvokeRequestDefinition)) {
            throw new IllegalArgumentException("Function definition must be a AWSInvokeRequestDefinition");
        }
        InvokeRequest invokeRequest = ((AWSInvokeRequestDefinition)definition).getInvokeRequest().clone();
        boolean isReactiveType = Publishers.isConvertibleToPublisher((Class)outputType.getType());
        if (isReactiveType) {
            Flowable invokeFlowable = Flowable.just((Object)invokeRequest).flatMap(req -> {
                this.encodeInput(input, invokeRequest);
                Future future = this.asyncClient.invokeAsync(req);
                return Flowable.fromFuture((Future)future, (Scheduler)Schedulers.from((Executor)this.ioExecutor));
            }).map(invokeResult -> this.decodeResult(definition, (Argument<O>)outputType.getFirstTypeVariable().orElse(Argument.OBJECT_ARGUMENT), (InvokeResult)invokeResult));
            invokeFlowable = invokeFlowable.onErrorResumeNext(throwable -> Flowable.error((Throwable)new FunctionExecutionException("Error executing AWS Lambda [" + definition.getName() + "]: " + throwable.getMessage(), (Throwable)throwable)));
            return (O)ConversionService.SHARED.convert((Object)invokeFlowable, outputType).orElseThrow(() -> new IllegalArgumentException("Unsupported Reactive type: " + outputType));
        }
        this.encodeInput(input, invokeRequest);
        InvokeResult invokeResult2 = this.asyncClient.invoke(invokeRequest);
        try {
            return (O)this.decodeResult(definition, outputType, invokeResult2);
        }
        catch (Exception e) {
            throw new FunctionExecutionException("Error executing AWS Lambda [" + definition.getName() + "]: " + e.getMessage(), e);
        }
    }

    private Object decodeResult(FunctionDefinition definition, Argument<O> outputType, InvokeResult invokeResult) {
        Integer statusCode = invokeResult.getStatusCode();
        if (statusCode >= 300) {
            throw new FunctionExecutionException("Error executing AWS Lambda [" + definition.getName() + "]: " + invokeResult.getFunctionError());
        }
        io.micronaut.core.io.buffer.ByteBuffer byteBuffer = this.byteBufferFactory.copiedBuffer(invokeResult.getPayload());
        return this.jsonMediaTypeCodec.decode(outputType, byteBuffer);
    }

    private void encodeInput(I input, InvokeRequest invokeRequest) {
        if (input != null) {
            ByteBuffer byteBuffer = this.jsonMediaTypeCodec.encode(input, this.byteBufferFactory).asNioBuffer();
            invokeRequest.setPayload(byteBuffer);
        }
    }

    public <I1, O2> Optional<FunctionInvoker<I1, O2>> choose(FunctionDefinition definition) {
        if (definition instanceof AWSInvokeRequestDefinition) {
            return Optional.of(this);
        }
        return Optional.empty();
    }
}

