/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.function.client.aop;

import io.micronaut.aop.MethodInterceptor;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.ReturnType;
import io.micronaut.function.client.FunctionDefinition;
import io.micronaut.function.client.FunctionDiscoveryClient;
import io.micronaut.function.client.FunctionInvoker;
import io.micronaut.function.client.FunctionInvokerChooser;
import io.micronaut.function.client.exceptions.FunctionExecutionException;
import io.micronaut.function.client.exceptions.FunctionNotFoundException;
import io.reactivex.Flowable;
import io.reactivex.Maybe;
import io.reactivex.MaybeSource;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;

@Singleton
public class FunctionClientAdvice
implements MethodInterceptor<Object, Object> {
    private final FunctionDiscoveryClient discoveryClient;
    private final FunctionInvokerChooser functionInvokerChooser;

    public FunctionClientAdvice(FunctionDiscoveryClient discoveryClient, FunctionInvokerChooser functionInvokerChooser) {
        this.discoveryClient = discoveryClient;
        this.functionInvokerChooser = functionInvokerChooser;
    }

    public Object intercept(MethodInvocationContext<Object, Object> context) {
        Map parameterValueMap = context.getParameterValueMap();
        int len = parameterValueMap.size();
        Map body = len == 1 ? parameterValueMap.values().iterator().next() : (len == 0 ? null : parameterValueMap);
        String functionName = context.stringValue(Named.class).orElse(NameUtils.hyphenate((String)context.getMethodName(), (boolean)true));
        Flowable functionDefinition = Flowable.fromPublisher(this.discoveryClient.getFunction(functionName));
        ReturnType returnType = context.getReturnType();
        Class javaReturnType = returnType.getType();
        if (Publishers.isConvertibleToPublisher((Class)javaReturnType)) {
            Maybe flowable = functionDefinition.firstElement().flatMap(def -> {
                FunctionInvoker functionInvoker = this.functionInvokerChooser.choose((FunctionDefinition)def).orElseThrow(() -> new FunctionNotFoundException(def.getName()));
                return (Maybe)functionInvoker.invoke((FunctionDefinition)def, body, Argument.of(Maybe.class, (Argument[])new Argument[]{returnType.getFirstTypeVariable().orElse(Argument.OBJECT_ARGUMENT)}));
            });
            flowable = flowable.switchIfEmpty((MaybeSource)Maybe.error((Throwable)new FunctionNotFoundException(functionName)));
            return ConversionService.SHARED.convert((Object)flowable, returnType.asArgument()).orElseThrow(() -> new FunctionExecutionException("Unsupported reactive type: " + returnType.getType()));
        }
        FunctionDefinition def2 = (FunctionDefinition)functionDefinition.blockingFirst();
        FunctionInvoker functionInvoker = this.functionInvokerChooser.choose(def2).orElseThrow(() -> new FunctionNotFoundException(def2.getName()));
        return functionInvoker.invoke(def2, body, returnType.asArgument());
    }
}

