/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.convert;

import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionError;
import io.micronaut.core.convert.DefaultMutableConversionService;
import io.micronaut.core.convert.exceptions.ConversionErrorException;
import io.micronaut.core.type.Argument;
import java.util.Optional;

public interface ConversionService {
    public static final ConversionService SHARED = new DefaultMutableConversionService();

    default public <T> Optional<T> convert(Object object, Class<T> targetType, ConversionContext context) {
        if (object == null) {
            return Optional.empty();
        }
        return this.convert(object, object.getClass(), targetType, context);
    }

    default public <S, T> Optional<T> convert(S object, Class<? super S> sourceType, Class<T> targetType, ConversionContext context) {
        return this.convert(object, targetType, context);
    }

    public <S, T> boolean canConvert(Class<S> var1, Class<T> var2);

    default public <T> Optional<T> convert(Object object, Class<T> targetType) {
        return this.convert(object, targetType, ConversionContext.DEFAULT);
    }

    default public <T> Optional<T> convert(Object object, Argument<T> targetType) {
        return this.convert(object, targetType.getType(), ConversionContext.of(targetType));
    }

    default public <S, T> Optional<T> convert(S object, Class<? super S> sourceType, Argument<T> targetType) {
        return this.convert(object, sourceType, targetType.getType(), ConversionContext.of(targetType));
    }

    default public <T> Optional<T> convert(Object object, ArgumentConversionContext<T> context) {
        return this.convert(object, context.getArgument().getType(), context);
    }

    @Nullable
    default public <T> T convertRequired(@Nullable Object value, Class<T> type) {
        if (value == null) {
            return null;
        }
        Argument<T> arg = Argument.of(type);
        return this.convertRequired(value, arg);
    }

    @Nullable
    default public <T> T convertRequired(@Nullable Object value, Argument<T> argument) {
        ArgumentConversionContext<T> context = ConversionContext.of(argument);
        return this.convertRequired(value, context);
    }

    default public <T> T convertRequired(Object value, ArgumentConversionContext<T> context) {
        Argument argument = context.getArgument();
        return this.convert(value, argument.getType(), context).orElseThrow(() -> ConversionService.newConversionError(context, argument, value));
    }

    private static <T> ConversionErrorException newConversionError(ArgumentConversionContext<T> context, Argument<T> argument, Object value) {
        Optional<ConversionError> lastError = context.getLastError();
        return lastError.map(conversionError -> new ConversionErrorException(context.getArgument(), (ConversionError)conversionError)).orElseGet(() -> new ConversionErrorException(context.getArgument(), new IllegalArgumentException("Cannot convert type [" + String.valueOf(value.getClass()) + "] to target type: " + String.valueOf(argument.getType()) + ". Considering defining a TypeConverter bean to handle this case.")));
    }
}

