/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.io.buffer;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.io.buffer.ByteArrayByteBuffer;
import io.micronaut.core.io.buffer.ByteBufferFactory;
import java.nio.ByteBuffer;

@Internal
public final class ByteArrayBufferFactory
implements ByteBufferFactory<Void, byte[]> {
    public static final ByteArrayBufferFactory INSTANCE = new ByteArrayBufferFactory();

    private ByteArrayBufferFactory() {
    }

    @Override
    public Void getNativeAllocator() {
        throw new UnsupportedOperationException("No native allocator");
    }

    public ByteArrayByteBuffer buffer() {
        return this.buffer(0);
    }

    public ByteArrayByteBuffer buffer(int initialCapacity) {
        return new ByteArrayByteBuffer(new byte[initialCapacity]);
    }

    public ByteArrayByteBuffer buffer(int initialCapacity, int maxCapacity) {
        return this.buffer(initialCapacity);
    }

    public ByteArrayByteBuffer copiedBuffer(byte[] bytes) {
        return this.wrap((byte[])bytes.clone());
    }

    public ByteArrayByteBuffer copiedBuffer(ByteBuffer nioBuffer) {
        int pos = nioBuffer.position();
        int lim = nioBuffer.limit();
        byte[] arr = new byte[lim - pos];
        nioBuffer.get(pos, arr, 0, arr.length);
        return this.wrap(arr);
    }

    public ByteArrayByteBuffer wrap(byte[] existing) {
        return new ByteArrayByteBuffer(existing);
    }
}

