/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.util;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;

public enum AnsiColour {
    RESET("\u001b[0m"),
    BLACK("\u001b[0;30m"),
    RED("\u001b[0;31m"),
    GREEN("\u001b[0;32m"),
    YELLOW("\u001b[0;33m"),
    BLUE("\u001b[0;34m"),
    MAGENTA("\u001b[0;35m"),
    CYAN("\u001b[0;36m"),
    WHITE("\u001b[0;37m"),
    BLACK_BOLD("\u001b[1;30m"),
    RED_BOLD("\u001b[1;31m"),
    GREEN_BOLD("\u001b[1;32m"),
    YELLOW_BOLD("\u001b[1;33m"),
    BLUE_BOLD("\u001b[1;34m"),
    MAGENTA_BOLD("\u001b[1;35m"),
    CYAN_BOLD("\u001b[1;36m"),
    WHITE_BOLD("\u001b[1;37m"),
    BLACK_UNDERLINED("\u001b[4;30m"),
    RED_UNDERLINED("\u001b[4;31m"),
    GREEN_UNDERLINED("\u001b[4;32m"),
    YELLOW_UNDERLINED("\u001b[4;33m"),
    BLUE_UNDERLINED("\u001b[4;34m"),
    MAGENTA_UNDERLINED("\u001b[4;35m"),
    CYAN_UNDERLINED("\u001b[4;36m"),
    WHITE_UNDERLINED("\u001b[4;37m"),
    BLACK_BACKGROUND("\u001b[40m"),
    RED_BACKGROUND("\u001b[41m"),
    GREEN_BACKGROUND("\u001b[42m"),
    YELLOW_BACKGROUND("\u001b[43m"),
    BLUE_BACKGROUND("\u001b[44m"),
    MAGENTA_BACKGROUND("\u001b[45m"),
    CYAN_BACKGROUND("\u001b[46m"),
    WHITE_BACKGROUND("\u001b[47m"),
    BLACK_BRIGHT("\u001b[0;90m"),
    RED_BRIGHT("\u001b[0;91m"),
    GREEN_BRIGHT("\u001b[0;92m"),
    YELLOW_BRIGHT("\u001b[0;93m"),
    BLUE_BRIGHT("\u001b[0;94m"),
    MAGENTA_BRIGHT("\u001b[0;95m"),
    CYAN_BRIGHT("\u001b[0;96m"),
    WHITE_BRIGHT("\u001b[0;97m"),
    BLACK_BOLD_BRIGHT("\u001b[1;90m"),
    RED_BOLD_BRIGHT("\u001b[1;91m"),
    GREEN_BOLD_BRIGHT("\u001b[1;92m"),
    YELLOW_BOLD_BRIGHT("\u001b[1;93m"),
    BLUE_BOLD_BRIGHT("\u001b[1;94m"),
    MAGENTA_BOLD_BRIGHT("\u001b[1;95m"),
    CYAN_BOLD_BRIGHT("\u001b[1;96m"),
    WHITE_BOLD_BRIGHT("\u001b[1;97m"),
    BLACK_BACKGROUND_BRIGHT("\u001b[0;100m"),
    RED_BACKGROUND_BRIGHT("\u001b[0;101m"),
    GREEN_BACKGROUND_BRIGHT("\u001b[0;102m"),
    YELLOW_BACKGROUND_BRIGHT("\u001b[0;103m"),
    BLUE_BACKGROUND_BRIGHT("\u001b[0;104m"),
    MAGENTA_BACKGROUND_BRIGHT("\u001b[0;105m"),
    CYAN_BACKGROUND_BRIGHT("\u001b[0;106m"),
    WHITE_BACKGROUND_BRIGHT("\u001b[0;107m");

    private final String code;

    private AnsiColour(String code) {
        this.code = code;
    }

    public static String cyan(String text) {
        if (AnsiColour.isSupported()) {
            return CYAN + text + RESET;
        }
        return text;
    }

    public static String brightCyan(String text) {
        if (AnsiColour.isSupported()) {
            return CYAN_BRIGHT + text + RESET;
        }
        return text;
    }

    public static String yellow(@NonNull String text) {
        if (AnsiColour.isSupported()) {
            return YELLOW + text + RESET;
        }
        return text;
    }

    public static String brightBlue(String text) {
        if (AnsiColour.isSupported()) {
            return BLUE_BRIGHT + text + RESET;
        }
        return text;
    }

    public static String magentaBold(String text) {
        if (AnsiColour.isSupported()) {
            return MAGENTA_BOLD + text + RESET;
        }
        return text;
    }

    public static String green(String text) {
        if (AnsiColour.isSupported()) {
            return GREEN + text + RESET;
        }
        return text;
    }

    public static String brightYellow(String text) {
        if (AnsiColour.isSupported()) {
            return YELLOW_BRIGHT + text + RESET;
        }
        return text;
    }

    @NonNull
    public static String formatObject(@Nullable Object object) {
        if (object instanceof CharSequence) {
            CharSequence charSequence = (CharSequence)object;
            return AnsiColour.green("\"" + charSequence + "\"");
        }
        if (object instanceof Number) {
            Number number = (Number)object;
            return AnsiColour.brightBlue(number.toString());
        }
        if (object == null) {
            return AnsiColour.brightBlue("null");
        }
        return AnsiColour.brightYellow(object.toString());
    }

    @NonNull
    public static String blue(@NonNull String text) {
        if (AnsiColour.isSupported()) {
            return BLUE + text + RESET;
        }
        return text;
    }

    public String toString() {
        return this.code;
    }

    public static boolean isSupported() {
        String os = System.getProperty("os.name").toLowerCase();
        return !os.contains("win") || System.console() != null;
    }
}

