/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.io;

import io.micronaut.core.annotation.Blocking;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.IOExceptionBiFunction;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IOUtils {
    private static final int BUFFER_MAX = 8192;
    private static final String SCHEME_FILE = "file";
    private static final String SCHEME_JAR = "jar";
    private static final String SCHEME_ZIP = "zip";
    private static final String SCHEME_WSJAR = "wsjar";
    private static final String COLON = ":";

    @Blocking
    public static void eachFile(@NonNull URL url, String path, @NonNull Consumer<Path> consumer) {
        try {
            IOUtils.eachFile(url.toURI(), path, consumer);
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Blocking
    public static void eachFile(@NonNull URI uri, String path, final @NonNull Consumer<Path> consumer) {
        ArrayList<Closeable> toClose = new ArrayList<Closeable>();
        try {
            Path myPath = IOUtils.resolvePath(uri, path, toClose, IOUtils::loadNestedJarUri);
            if (myPath != null) {
                final Path finalMyPath = myPath;
                Files.walkFileTree(myPath, Collections.emptySet(), 1, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFile(Path currentPath, BasicFileAttributes attrs) throws IOException {
                        if (currentPath.equals(finalMyPath) || Files.isHidden(currentPath) || currentPath.getFileName().startsWith(".")) {
                            return FileVisitResult.CONTINUE;
                        }
                        consumer.accept(currentPath);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFileFailed(Path file, IOException exc) {
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
        }
        catch (IOException iOException) {
            for (Closeable closeable : toClose) {
                try {
                    closeable.close();
                }
                catch (IOException iOException2) {}
            }
        }
        finally {
            for (Closeable closeable : toClose) {
                try {
                    closeable.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Nullable
    static Path resolvePath(@NonNull URI uri, String path, List<Closeable> toClose, IOExceptionBiFunction<List<Closeable>, String, Path> loadNestedJarUriFunction) throws IOException {
        String scheme = uri.getScheme();
        try {
            if (SCHEME_JAR.equals(scheme) || SCHEME_ZIP.equals(scheme) || SCHEME_WSJAR.equals(scheme)) {
                Object jarUri = uri.getRawSchemeSpecificPart();
                int sep = ((String)jarUri).lastIndexOf("!/");
                if (sep != -1) {
                    jarUri = ((String)jarUri).substring(0, sep);
                }
                if (!((String)jarUri).startsWith("file:")) {
                    jarUri = ((String)jarUri).startsWith("/") ? "file:" + (String)jarUri : "file:/" + (String)jarUri;
                }
                jarUri = (String)jarUri + "!/";
                return loadNestedJarUriFunction.apply(toClose, (String)jarUri).resolve(path);
            }
            if (SCHEME_FILE.equals(scheme)) {
                return Paths.get(uri).resolve(path);
            }
            return Paths.get(uri);
        }
        catch (FileSystemNotFoundException e) {
            return null;
        }
    }

    private static Path loadNestedJarUri(List<Closeable> toClose, String jarUri) throws IOException {
        int sep = jarUri.lastIndexOf("!/");
        if (sep == -1) {
            return Paths.get(URI.create(jarUri));
        }
        Path jarPath = IOUtils.loadNestedJarUri(toClose, jarUri.substring(0, sep));
        if (Files.isDirectory(jarPath, new LinkOption[0])) {
            return jarPath;
        }
        FileSystem zipfs = FileSystems.newFileSystem(jarPath, (ClassLoader)null);
        toClose.add(0, zipfs);
        return zipfs.getPath(jarUri.substring(sep + 1), new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Blocking
    public static String readText(BufferedReader reader) throws IOException {
        StringBuilder answer = new StringBuilder();
        if (reader == null) {
            return answer.toString();
        }
        char[] charBuffer = new char[8192];
        try {
            int nbCharRead;
            while ((nbCharRead = reader.read(charBuffer)) != -1) {
                answer.append(charBuffer, 0, nbCharRead);
            }
            BufferedReader temp = reader;
            reader = null;
            ((Reader)temp).close();
        }
        finally {
            block11: {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException e) {
                    Logger logger = LoggerFactory.getLogger(Logger.class);
                    if (!logger.isWarnEnabled()) break block11;
                    logger.warn("Failed to close reader: " + e.getMessage(), (Throwable)e);
                }
            }
        }
        return answer.toString();
    }
}

