/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.type;

import io.micronaut.core.annotation.AnnotatedElement;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.type.DefaultArgument;
import io.micronaut.core.type.DefaultGenericPlaceholder;
import io.micronaut.core.type.TypeInformation;
import io.micronaut.core.util.ArrayUtils;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public interface Argument<T>
extends TypeInformation<T>,
AnnotatedElement,
Type {
    public static final Argument<String> STRING = Argument.of(String.class);
    public static final Argument<Integer> INT = Argument.of(Integer.TYPE);
    public static final Argument<Long> LONG = Argument.of(Long.TYPE);
    public static final Argument<Float> FLOAT = Argument.of(Float.TYPE);
    public static final Argument<Double> DOUBLE = Argument.of(Double.TYPE);
    public static final Argument<Void> VOID = Argument.of(Void.TYPE);
    public static final Argument<Byte> BYTE = Argument.of(Byte.TYPE);
    public static final Argument<Boolean> BOOLEAN = Argument.of(Boolean.TYPE);
    public static final Argument<Character> CHAR = Argument.of(Character.TYPE);
    public static final Argument<Short> SHORT = Argument.of(Short.TYPE);
    public static final Argument[] ZERO_ARGUMENTS = new Argument[0];
    public static final Argument<Object> OBJECT_ARGUMENT = Argument.of(Object.class);
    public static final Argument<List<String>> LIST_OF_STRING = Argument.listOf(String.class);
    public static final Argument<Void> VOID_OBJECT = Argument.of(Void.class);

    @Override
    @NonNull
    public String getName();

    public boolean equalsType(@Nullable Argument<?> var1);

    public int typeHashCode();

    default public boolean isTypeVariable() {
        return false;
    }

    default public boolean isInstance(@Nullable Object o) {
        if (o == null) {
            return false;
        }
        return this.getType().isInstance(o);
    }

    default public boolean isAssignableFrom(@NonNull Class<?> candidateType) {
        return this.getType().isAssignableFrom(Objects.requireNonNull(candidateType, "Candidate type cannot be null"));
    }

    default public boolean isAssignableFrom(@NonNull Argument<?> candidateArgument) {
        Objects.requireNonNull(candidateArgument, "Candidate type cannot be null");
        if (!this.isAssignableFrom(candidateArgument.getType())) {
            return false;
        }
        Argument[] typeParameters = this.getTypeParameters();
        Argument[] candidateArgumentTypeParameters = candidateArgument.getTypeParameters();
        if (typeParameters.length == 0) {
            return candidateArgumentTypeParameters.length >= 0;
        }
        if (candidateArgumentTypeParameters.length == 0) {
            for (Argument typeParameter : typeParameters) {
                if (typeParameter.getType() == Object.class) continue;
                return false;
            }
            return true;
        }
        for (int i = 0; i < typeParameters.length; ++i) {
            Argument typeParameter = typeParameters[i];
            Argument candidateArgumentTypeParameter = candidateArgumentTypeParameters[i];
            if (typeParameter.isAssignableFrom(candidateArgumentTypeParameter)) continue;
            return false;
        }
        return true;
    }

    @NonNull
    default public Argument<T> withName(@Nullable String name) {
        return Argument.of(this.getType(), name, this.getAnnotationMetadata(), this.getTypeParameters());
    }

    @NonNull
    default public Argument<T> withAnnotationMetadata(@NonNull AnnotationMetadata annotationMetadata) {
        return Argument.of(this.getType(), this.getName(), annotationMetadata, this.getTypeParameters());
    }

    @NonNull
    public static Class<?>[] toClassArray(Argument<?> ... arguments) {
        if (ArrayUtils.isEmpty(arguments)) {
            return ReflectionUtils.EMPTY_CLASS_ARRAY;
        }
        Class[] types = new Class[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            Argument<?> argument = arguments[i];
            types[i] = argument.getType();
        }
        return types;
    }

    @NonNull
    public static String toString(Argument<?> ... arguments) {
        if (ArrayUtils.isNotEmpty(arguments)) {
            StringBuilder baseString = new StringBuilder();
            for (int i = 0; i < arguments.length; ++i) {
                Argument<?> argument = arguments[i];
                baseString.append(argument.toString());
                if (i == arguments.length - 1) continue;
                baseString.append(',');
            }
            return baseString.toString();
        }
        return "";
    }

    @NonNull
    public static <T> Argument<T> of(@NonNull Class<T> type, @Nullable String name, Argument<?> ... typeParameters) {
        return new DefaultArgument<T>(type, name, AnnotationMetadata.EMPTY_METADATA, typeParameters);
    }

    @NonNull
    public static <T> Argument<T> ofTypeVariable(@NonNull Class<T> type, @Nullable String name, @Nullable AnnotationMetadata annotationMetadata, Argument<?> ... typeParameters) {
        return new DefaultGenericPlaceholder<T>(type, name, annotationMetadata, typeParameters);
    }

    @NonNull
    public static <T> Argument<T> ofTypeVariable(@NonNull Class<T> type, @Nullable String argumentName, @NonNull String variableName, @Nullable AnnotationMetadata annotationMetadata, Argument<?> ... typeParameters) {
        Objects.requireNonNull(variableName, "Variable name cannot be null");
        return new DefaultGenericPlaceholder<T>(type, argumentName, variableName, annotationMetadata, typeParameters);
    }

    @NonNull
    public static <T> Argument<T> ofTypeVariable(@NonNull Class<T> type, @Nullable String name) {
        return new DefaultGenericPlaceholder<T>(type, name, AnnotationMetadata.EMPTY_METADATA, new Argument[0]);
    }

    @NonNull
    public static <T> Argument<T> ofTypeVariable(@NonNull Class<T> type, @Nullable String argumentName, @NonNull String variableName) {
        return new DefaultGenericPlaceholder<T>(type, argumentName, variableName, AnnotationMetadata.EMPTY_METADATA, new Argument[0]);
    }

    @NonNull
    public static <T> Argument<T> of(@NonNull Class<T> type, @Nullable String name, @Nullable AnnotationMetadata annotationMetadata, Argument<?> ... typeParameters) {
        return new DefaultArgument<T>(type, name, annotationMetadata, typeParameters);
    }

    @NonNull
    public static <T> Argument<T> of(@NonNull Class<T> type, @Nullable AnnotationMetadata annotationMetadata, Argument<?> ... typeParameters) {
        return new DefaultArgument<T>(type, annotationMetadata, typeParameters);
    }

    @NonNull
    public static <T> Argument<T> of(@NonNull Class<T> type, @Nullable String name) {
        return new DefaultArgument<T>(type, name, AnnotationMetadata.EMPTY_METADATA, ZERO_ARGUMENTS);
    }

    @NonNull
    public static <T> Argument<T> of(@NonNull Class<T> type, Argument<?> ... typeParameters) {
        if (ArrayUtils.isEmpty(typeParameters)) {
            return Argument.of(type);
        }
        return new DefaultArgument<T>(type, null, AnnotationMetadata.EMPTY_METADATA, typeParameters);
    }

    @NonNull
    public static Argument<?> of(@NonNull Type type) {
        Objects.requireNonNull(type, "Type cannot be null");
        if (type instanceof Class) {
            Class class1 = (Class)type;
            return Argument.of(class1);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            Type rawType = pt.getRawType();
            if (rawType instanceof Class) {
                Class rawClass = (Class)rawType;
                Object[] actualTypeArguments = pt.getActualTypeArguments();
                if (ArrayUtils.isNotEmpty(actualTypeArguments)) {
                    Argument[] typeArguments = new Argument[actualTypeArguments.length];
                    for (int i = 0; i < actualTypeArguments.length; ++i) {
                        Object typeArgument = actualTypeArguments[i];
                        if (!(typeArgument instanceof Class) && !(typeArgument instanceof ParameterizedType)) {
                            return Argument.of(rawClass);
                        }
                        typeArguments[i] = Argument.of((Type)typeArgument);
                    }
                    return Argument.of(rawClass, typeArguments);
                }
                return Argument.of(rawClass);
            }
            throw new IllegalArgumentException("A ParameterizedType that has a raw type that is not a class cannot be converted to an argument");
        }
        throw new IllegalArgumentException("Type [" + String.valueOf(type) + "] must be a Class or ParameterizedType");
    }

    @NonNull
    public static <T> Argument<T> of(@NonNull Class<T> type) {
        return new DefaultArgument<T>(type, null, AnnotationMetadata.EMPTY_METADATA, Collections.emptyMap(), ZERO_ARGUMENTS);
    }

    @NonNull
    public static <T> Argument<T> ofInstance(@NonNull T instance) {
        return Argument.of(instance.getClass());
    }

    @NonNull
    public static <T> Argument<T> of(@NonNull Class<T> type, Class<?> ... typeParameters) {
        return Argument.of(type, AnnotationMetadata.EMPTY_METADATA, typeParameters);
    }

    @NonNull
    public static <T> Argument<T> of(@NonNull Class<T> type, @Nullable AnnotationMetadata annotationMetadata, @Nullable Class<?>[] typeParameters) {
        int len;
        if (ArrayUtils.isEmpty(typeParameters)) {
            return Argument.of(type, annotationMetadata, new Argument[0]);
        }
        TypeVariable<Class<T>>[] parameters = type.getTypeParameters();
        if (parameters.length != (len = typeParameters.length)) {
            throw new IllegalArgumentException("Type parameter length does not match. Required: " + parameters.length + ", Specified: " + len);
        }
        Argument[] typeArguments = new Argument[len];
        for (int i = 0; i < parameters.length; ++i) {
            TypeVariable<Class<T>> parameter = parameters[i];
            typeArguments[i] = Argument.ofTypeVariable(typeParameters[i], parameter.getName());
        }
        return new DefaultArgument<T>(type, annotationMetadata != null ? annotationMetadata : AnnotationMetadata.EMPTY_METADATA, typeArguments);
    }

    @NonNull
    public static <T> Argument<List<T>> listOf(@NonNull Class<T> type) {
        return Argument.listOf(Argument.of(type, "E"));
    }

    @NonNull
    public static <T> Argument<List<T>> listOf(@NonNull Argument<T> type) {
        return Argument.of(List.class, "list", type);
    }

    @NonNull
    public static <T> Argument<Set<T>> setOf(@NonNull Class<T> type) {
        return Argument.setOf(Argument.of(type, "E"));
    }

    @NonNull
    public static <T> Argument<Set<T>> setOf(@NonNull Argument<T> type) {
        return Argument.of(Set.class, "set", type);
    }

    @NonNull
    public static <K, V> Argument<Map<K, V>> mapOf(@NonNull Class<K> keyType, @NonNull Class<V> valueType) {
        return Argument.mapOf(Argument.of(keyType, "K"), Argument.of(valueType, "V"));
    }

    @NonNull
    public static <K, V> Argument<Map<K, V>> mapOf(@NonNull Argument<K> keyType, @NonNull Argument<V> valueType) {
        return Argument.of(Map.class, "map", keyType, valueType);
    }

    @NonNull
    public static <T> Argument<Optional<T>> optionalOf(@NonNull Class<T> optionalValueClass) {
        return Argument.optionalOf(Argument.of(optionalValueClass, "T"));
    }

    @NonNull
    public static <T> Argument<Optional<T>> optionalOf(@NonNull Argument<T> optionalValueArgument) {
        return Argument.of(Optional.class, "optional", optionalValueArgument);
    }
}

