/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.io.value;

import io.micronaut.core.io.ResourceLoader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Optional;
import java.util.stream.Stream;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
abstract class ValueResourceLoader
implements ResourceLoader {
    private final String prefix;

    ValueResourceLoader(String prefix) {
        this.prefix = prefix;
    }

    @Override
    public final ResourceLoader forBase(String basePath) {
        throw new UnsupportedOperationException("This resource loader (" + this.prefix + ") does not support paths");
    }

    @Override
    public final boolean supportsPrefix(String path) {
        return path.startsWith(this.prefix);
    }

    @Override
    public final Stream<URL> getResources(String name) {
        return this.getResource(name).stream();
    }

    @Override
    public final Optional<URL> getResource(String path) {
        return this.extractWithPrefix(path).map(bytes -> {
            String scheme = this.prefix;
            if (scheme.endsWith(":")) {
                scheme = scheme.substring(0, scheme.length() - 1);
            }
            try {
                return new URL(scheme, null, -1, path.substring(scheme.length()), new StreamHandlerImpl((byte[])bytes));
            }
            catch (MalformedURLException e) {
                throw new AssertionError("Shouldn't happen since host is null", e);
            }
        });
    }

    @Override
    public final Optional<InputStream> getResourceAsStream(String path) {
        return this.extractWithPrefix(path).map(ByteArrayInputStream::new);
    }

    private Optional<byte[]> extractWithPrefix(String path) {
        if (!this.supportsPrefix(path)) {
            throw new IllegalArgumentException("Unexpected prefix: " + path);
        }
        return this.extract(path.substring(this.prefix.length()));
    }

    protected abstract Optional<byte[]> extract(String var1);

    private static final class StreamHandlerImpl
    extends URLStreamHandler {
        private final byte[] bytes;

        StreamHandlerImpl(byte[] bytes) {
            this.bytes = bytes;
        }

        @Override
        protected URLConnection openConnection(URL u) throws IOException {
            return new FixedURLConnection(u, this.bytes);
        }
    }

    private static final class FixedURLConnection
    extends URLConnection {
        private final InputStream stream;
        private final int length;

        FixedURLConnection(URL url, byte[] bytes) {
            super(url);
            this.length = bytes.length;
            this.stream = new ByteArrayInputStream(bytes);
        }

        @Override
        public void connect() {
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return this.stream;
        }

        @Override
        public long getContentLengthLong() {
            return this.length;
        }
    }
}

