/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.beans;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.beans.BeanInfo;
import io.micronaut.core.beans.BeanMap;
import io.micronaut.core.beans.Introspector;
import io.micronaut.core.beans.PropertyDescriptor;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.reflect.ReflectionUtils;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

@Internal
@Deprecated
class ReflectionBeanMap<T>
implements BeanMap<T> {
    private final BeanInfo<T> beanInfo;
    private final Map<String, PropertyDescriptor> propertyDescriptors;
    private final T bean;

    ReflectionBeanMap(T bean) {
        Objects.requireNonNull(bean, "Bean cannot be null");
        this.bean = bean;
        this.beanInfo = Introspector.getBeanInfo(bean.getClass());
        this.propertyDescriptors = this.beanInfo.getPropertyDescriptors();
    }

    @Override
    @NonNull
    public Class<T> getBeanType() {
        return this.beanInfo.getBeanClass();
    }

    @Override
    public int size() {
        return this.propertyDescriptors.size();
    }

    @Override
    public boolean isEmpty() {
        return this.propertyDescriptors.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.propertyDescriptors.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values().contains(value);
    }

    @Override
    public Object get(Object key) {
        Method readMethod;
        PropertyDescriptor propertyDescriptor = this.propertyDescriptors.get(key);
        if (propertyDescriptor != null && (readMethod = propertyDescriptor.getReadMethod()) != null) {
            return ReflectionUtils.invokeMethod(this.bean, readMethod, new Object[0]);
        }
        return null;
    }

    @Override
    public Object put(String key, Object value) {
        Class<?> targetType;
        Optional<?> converted;
        Method writeMethod;
        PropertyDescriptor propertyDescriptor = this.propertyDescriptors.get(key);
        if (propertyDescriptor != null && (writeMethod = propertyDescriptor.getWriteMethod()) != null && (converted = ConversionService.SHARED.convert(value, targetType = writeMethod.getParameterTypes()[0])).isPresent()) {
            return ReflectionUtils.invokeMethod(this.bean, writeMethod, converted.get());
        }
        return null;
    }

    @Override
    public Object remove(Object key) {
        throw new UnsupportedOperationException("Removal is not supported");
    }

    @Override
    public void putAll(Map<? extends String, ?> m) {
        for (Map.Entry<String, ?> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Removal is not supported");
    }

    @Override
    public Set<String> keySet() {
        return this.propertyDescriptors.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.keySet().stream().map(this::get).collect(Collectors.toList());
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.keySet().stream().map(key -> new Map.Entry<String, Object>(){

            @Override
            public String getKey() {
                return key;
            }

            @Override
            public Object getValue() {
                return ReflectionBeanMap.this.get(key);
            }

            @Override
            public Object setValue(Object value) {
                return ReflectionBeanMap.this.put(key, value);
            }
        }).collect(Collectors.toSet());
    }
}

