/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.convert.value;

import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.ConvertibleMultiValues;
import io.micronaut.core.type.Argument;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class ConvertibleMultiValuesMap<V>
implements ConvertibleMultiValues<V> {
    public static final ConvertibleMultiValues EMPTY = new ConvertibleMultiValuesMap(Collections.emptyMap());
    protected final Map<CharSequence, List<V>> values;
    private final ConversionService<?> conversionService;

    public ConvertibleMultiValuesMap() {
        this(new LinkedHashMap<CharSequence, List<V>>(), ConversionService.SHARED);
    }

    public ConvertibleMultiValuesMap(Map<CharSequence, List<V>> values) {
        this(values, ConversionService.SHARED);
    }

    public ConvertibleMultiValuesMap(Map<CharSequence, List<V>> values, ConversionService<?> conversionService) {
        this.values = this.wrapValues(values);
        this.conversionService = conversionService;
    }

    @Override
    public <T> Optional<T> get(CharSequence name, ArgumentConversionContext<T> conversionContext) {
        List<V> values = this.getAll(name);
        if (!values.isEmpty()) {
            boolean hasSingleEntry;
            boolean bl = hasSingleEntry = values.size() == 1;
            if (hasSingleEntry) {
                V v = values.iterator().next();
                if (conversionContext.getArgument().getType().isInstance(v)) {
                    return Optional.of(v);
                }
                return this.conversionService.convert(v, conversionContext);
            }
            return this.conversionService.convert(values, conversionContext);
        }
        Argument<T> argument = conversionContext.getArgument();
        if (Map.class.isAssignableFrom(argument.getType())) {
            Argument<Object> valueType = argument.getTypeVariable("V").orElse(Argument.OBJECT_ARGUMENT);
            Map<String, Object> map = this.subMap(name.toString(), valueType);
            if (map.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(map);
        }
        return Optional.empty();
    }

    @Override
    public List<V> getAll(CharSequence name) {
        List<V> value = this.values.get(name);
        if (value != null) {
            return Collections.unmodifiableList(value);
        }
        return Collections.emptyList();
    }

    @Override
    public V get(CharSequence name) {
        List<V> all = this.getAll(name);
        if (all.isEmpty()) {
            return null;
        }
        return all.get(0);
    }

    @Override
    public Set<String> names() {
        return this.values.keySet().stream().map(CharSequence::toString).collect(Collectors.toSet());
    }

    @Override
    public Collection<List<V>> values() {
        return Collections.unmodifiableCollection(this.values.values());
    }

    protected Map<CharSequence, List<V>> wrapValues(Map<CharSequence, List<V>> values) {
        return Collections.unmodifiableMap(values);
    }
}

