/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.caffeine.cache;

import io.micronaut.caffeine.cache.CacheLoader;
import io.micronaut.caffeine.cache.Caffeine;
import io.micronaut.caffeine.cache.MpscGrowableArrayQueue;
import io.micronaut.caffeine.cache.Ticker;
import io.micronaut.caffeine.cache.WSLS;

final class WSLSR<K, V>
extends WSLS<K, V> {
    final Ticker ticker;
    volatile long refreshAfterWriteNanos;
    final MpscGrowableArrayQueue<Runnable> writeBuffer;

    WSLSR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
        super(builder, cacheLoader, async);
        this.ticker = builder.getTicker();
        this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        this.writeBuffer = new MpscGrowableArrayQueue(4, WRITE_BUFFER_MAX);
    }

    @Override
    public Ticker expirationTicker() {
        return this.ticker;
    }

    @Override
    protected boolean refreshAfterWrite() {
        return true;
    }

    @Override
    protected long refreshAfterWriteNanos() {
        return this.refreshAfterWriteNanos;
    }

    @Override
    protected void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
        this.refreshAfterWriteNanos = refreshAfterWriteNanos;
    }

    @Override
    protected MpscGrowableArrayQueue<Runnable> writeBuffer() {
        return this.writeBuffer;
    }

    @Override
    protected boolean buffersWrites() {
        return true;
    }
}

