/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.writer;

import io.micronaut.asm.ClassVisitor;
import io.micronaut.asm.ClassWriter;
import io.micronaut.asm.MethodVisitor;
import io.micronaut.asm.Opcodes;
import io.micronaut.asm.Type;
import io.micronaut.asm.commons.GeneratorAdapter;
import io.micronaut.asm.commons.Method;
import io.micronaut.context.AbstractExecutableMethod;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.inject.annotation.AnnotationMetadataReference;
import io.micronaut.inject.annotation.AnnotationMetadataWriter;
import io.micronaut.inject.writer.AbstractAnnotationMetadataWriter;
import io.micronaut.inject.writer.BeanDefinitionWriter;
import io.micronaut.inject.writer.ClassWriterOutputVisitor;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;

@Internal
public class ExecutableMethodWriter
extends AbstractAnnotationMetadataWriter
implements Opcodes {
    public static final String FIELD_PARENT = "$parent";
    protected static final Method METHOD_INVOKE_INTERNAL = Method.getMethod((java.lang.reflect.Method)ReflectionUtils.getRequiredInternalMethod(AbstractExecutableMethod.class, (String)"invokeInternal", (Class[])new Class[]{Object.class, Object[].class}));
    protected final Type methodType;
    private final ClassWriter classWriter;
    private final String className;
    private final String internalName;
    private final String beanFullClassName;
    private final String methodProxyShortName;
    private final boolean isInterface;
    private String outerClassName = null;
    private boolean isStatic = false;
    private final Map<String, GeneratorAdapter> loadTypeMethods = new HashMap<String, GeneratorAdapter>();

    public ExecutableMethodWriter(String beanFullClassName, String methodClassName, String methodProxyShortName, boolean isInterface, AnnotationMetadata annotationMetadata) {
        super(methodClassName, annotationMetadata, false);
        this.classWriter = new ClassWriter(3);
        this.beanFullClassName = beanFullClassName;
        this.methodProxyShortName = methodProxyShortName;
        this.className = methodClassName;
        this.internalName = ExecutableMethodWriter.getInternalName(methodClassName);
        this.methodType = ExecutableMethodWriter.getObjectType(methodClassName);
        this.isInterface = isInterface;
    }

    public String getClassName() {
        return this.className;
    }

    public String getInternalName() {
        return this.internalName;
    }

    public void makeInner(String outerName, ClassWriter outerClassWriter) {
        outerClassWriter.visitInnerClass(this.internalName, ExecutableMethodWriter.getInternalName(outerName), this.methodProxyShortName.substring(1), 0);
        this.classWriter.visitOuterClass(ExecutableMethodWriter.getInternalName(outerName), null, null);
        if (!this.isStatic) {
            this.classWriter.visitField(18, FIELD_PARENT, ExecutableMethodWriter.getTypeDescriptor(outerName), null, null);
        }
        this.outerClassName = outerName;
    }

    public void visitMethod(Object declaringType, Object returnType, Object genericReturnType, Map<String, Object> returnTypeGenericTypes, String methodName, Map<String, Object> argumentTypes, Map<String, AnnotationMetadata> argumentAnnotationMetadata, Map<String, Map<String, Object>> genericTypes) {
        String constructorDescriptor;
        GeneratorAdapter executorMethodConstructor;
        boolean hasOuter;
        Type declaringTypeObject = ExecutableMethodWriter.getTypeReference(declaringType);
        boolean hasArgs = !argumentTypes.isEmpty();
        List<Object> argumentTypeClasses = hasArgs ? argumentTypes.values() : Collections.emptyList();
        int modifiers = this.isStatic ? 9 : 1;
        this.classWriter.visit(52, modifiers, this.internalName, null, Type.getInternalName(AbstractExecutableMethod.class), null);
        if (!(this.annotationMetadata instanceof AnnotationMetadataReference)) {
            this.writeAnnotationMetadataStaticInitializer(this.classWriter);
        }
        this.writeGetAnnotationMetadataMethod(this.classWriter);
        boolean bl = hasOuter = this.outerClassName != null && !this.isStatic;
        if (hasOuter) {
            executorMethodConstructor = this.startConstructor((ClassVisitor)this.classWriter, this.outerClassName);
            constructorDescriptor = ExecutableMethodWriter.getConstructorDescriptor(this.outerClassName);
        } else {
            executorMethodConstructor = this.startConstructor((ClassVisitor)this.classWriter);
            constructorDescriptor = "()V";
        }
        GeneratorAdapter constructorWriter = new GeneratorAdapter((MethodVisitor)executorMethodConstructor, 1, "<init>", constructorDescriptor);
        if (hasOuter) {
            constructorWriter.loadThis();
            constructorWriter.loadArg(0);
            constructorWriter.putField(this.methodType, FIELD_PARENT, ExecutableMethodWriter.getObjectType(this.outerClassName));
        }
        constructorWriter.loadThis();
        constructorWriter.loadThis();
        constructorWriter.push(declaringTypeObject);
        constructorWriter.push(methodName);
        if (genericReturnType instanceof Class && ((Class)genericReturnType).isPrimitive()) {
            Class javaType = (Class)genericReturnType;
            String constantName = javaType.getName().toUpperCase(Locale.ENGLISH);
            Type type = Type.getType(Argument.class);
            constructorWriter.getStatic(type, constantName, type);
        } else {
            BeanDefinitionWriter.buildArgumentWithGenerics(constructorWriter, methodName, Collections.singletonMap(genericReturnType, returnTypeGenericTypes));
        }
        if (hasArgs) {
            BeanDefinitionWriter.pushBuildArgumentsForMethod(ExecutableMethodWriter.getTypeReferenceForName(this.getClassName(), new String[0]), this.classWriter, constructorWriter, argumentTypes, argumentAnnotationMetadata, genericTypes, this.loadTypeMethods);
            this.invokeConstructor((MethodVisitor)executorMethodConstructor, AbstractExecutableMethod.class, Class.class, String.class, Argument.class, Argument[].class);
        } else {
            this.invokeConstructor((MethodVisitor)executorMethodConstructor, AbstractExecutableMethod.class, Class.class, String.class, Argument.class);
        }
        constructorWriter.visitInsn(177);
        constructorWriter.visitMaxs(13, 1);
        String invokeDescriptor = METHOD_INVOKE_INTERNAL.getDescriptor();
        String invokeInternalName = METHOD_INVOKE_INTERNAL.getName();
        GeneratorAdapter invokeMethod = new GeneratorAdapter(this.classWriter.visitMethod(1, invokeInternalName, invokeDescriptor, null, null), 1, invokeInternalName, invokeDescriptor);
        this.buildInvokeMethod(declaringTypeObject, methodName, returnType, argumentTypeClasses, invokeMethod);
        for (GeneratorAdapter method : this.loadTypeMethods.values()) {
            method.visitMaxs(3, 1);
            method.visitEnd();
        }
    }

    protected void buildInvokeMethod(Type declaringTypeObject, String methodName, Object returnType, Collection<Object> argumentTypes, GeneratorAdapter invokeMethodVisitor) {
        String methodDescriptor;
        boolean hasArgs;
        Type returnTypeObject = ExecutableMethodWriter.getTypeReference(returnType);
        invokeMethodVisitor.visitVarInsn(25, 1);
        ExecutableMethodWriter.pushCastToType((MethodVisitor)invokeMethodVisitor, this.beanFullClassName);
        boolean bl = hasArgs = !argumentTypes.isEmpty();
        if (hasArgs) {
            methodDescriptor = ExecutableMethodWriter.getMethodDescriptor(returnType, argumentTypes);
            int argCount = argumentTypes.size();
            Iterator<Object> argIterator = argumentTypes.iterator();
            for (int i = 0; i < argCount; ++i) {
                invokeMethodVisitor.visitVarInsn(25, 2);
                invokeMethodVisitor.push(i);
                invokeMethodVisitor.visitInsn(50);
                ExecutableMethodWriter.pushCastToType((MethodVisitor)invokeMethodVisitor, argIterator.next());
            }
        } else {
            methodDescriptor = ExecutableMethodWriter.getMethodDescriptor(returnType, Collections.emptyList());
        }
        invokeMethodVisitor.visitMethodInsn(this.isInterface ? 185 : 182, declaringTypeObject.getInternalName(), methodName, methodDescriptor, this.isInterface);
        if (returnTypeObject.equals((Object)Type.VOID_TYPE)) {
            invokeMethodVisitor.visitInsn(1);
        } else {
            ExecutableMethodWriter.pushBoxPrimitiveIfNecessary(returnType, (MethodVisitor)invokeMethodVisitor);
        }
        invokeMethodVisitor.visitInsn(176);
        invokeMethodVisitor.visitMaxs(13, 1);
        invokeMethodVisitor.visitEnd();
    }

    public void makeStaticInner(String parentInternalName, ClassWriter classWriter) {
        this.isStatic = true;
        this.makeInner(parentInternalName, classWriter);
    }

    @Override
    public void accept(ClassWriterOutputVisitor classWriterOutputVisitor) throws IOException {
        AnnotationMetadataWriter annotationMetadataWriter = this.getAnnotationMetadataWriter();
        if (annotationMetadataWriter != null) {
            annotationMetadataWriter.accept(classWriterOutputVisitor);
        }
        try (OutputStream outputStream = classWriterOutputVisitor.visitClass(this.className);){
            outputStream.write(this.classWriter.toByteArray());
        }
    }

    @Override
    @Nonnull
    protected final GeneratorAdapter beginAnnotationMetadataMethod(ClassWriter classWriter) {
        return this.startProtectedMethod(classWriter, "resolveAnnotationMetadata", AnnotationMetadata.class.getName(), new String[0]);
    }
}

