/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.qualifiers;

import io.micronaut.context.Qualifier;
import io.micronaut.core.annotation.Internal;
import io.micronaut.inject.BeanType;
import java.lang.annotation.Annotation;
import java.util.stream.Stream;

@Internal
class AnnotationStereotypeQualifier<T>
implements Qualifier<T> {
    private final Class<? extends Annotation> stereotype;

    AnnotationStereotypeQualifier(Class<? extends Annotation> stereotype) {
        this.stereotype = stereotype;
    }

    @Override
    public <BT extends BeanType<T>> Stream<BT> reduce(Class<T> beanType, Stream<BT> candidates) {
        return candidates.filter(candidate -> candidate.getAnnotationMetadata().hasStereotype(this.stereotype));
    }

    public String toString() {
        return "@" + this.stereotype.getSimpleName();
    }
}

