/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.processing;

import javax.lang.model.element.Element;
import javax.lang.model.element.Name;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;

public class JavaModelUtils {
    public static String getClassName(TypeElement typeElement) {
        Name qualifiedName = typeElement.getQualifiedName();
        NestingKind nestingKind = null;
        try {
            nestingKind = typeElement.getNestingKind();
            if (nestingKind == NestingKind.MEMBER) {
                TypeElement enclosingElement = typeElement;
                StringBuilder builder = new StringBuilder();
                while (nestingKind == NestingKind.MEMBER) {
                    builder.insert(0, '$').insert(1, enclosingElement.getSimpleName());
                    Element enclosing = enclosingElement.getEnclosingElement();
                    if (!(enclosing instanceof TypeElement)) break;
                    enclosingElement = (TypeElement)enclosing;
                    nestingKind = enclosingElement.getNestingKind();
                }
                Name enclosingName = enclosingElement.getQualifiedName();
                return enclosingName.toString() + builder;
            }
            return qualifiedName.toString();
        }
        catch (RuntimeException e) {
            return qualifiedName.toString();
        }
    }
}

