/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.annotation;

import io.micronaut.context.annotation.AliasFor;
import io.micronaut.context.annotation.Aliases;
import io.micronaut.context.annotation.DefaultScope;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationUtil;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.io.service.ServiceDefinition;
import io.micronaut.core.io.service.SoftServiceLoader;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.core.value.OptionalValues;
import io.micronaut.inject.annotation.AnnotationMapper;
import io.micronaut.inject.annotation.DefaultAnnotationMetadata;
import io.micronaut.inject.annotation.NamedAnnotationMapper;
import io.micronaut.inject.annotation.TypedAnnotationMapper;
import io.micronaut.inject.visitor.VisitorContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Scope;

public abstract class AbstractAnnotationMetadataBuilder<T, A> {
    private static final Map<String, List<AnnotationMapper>> ANNOTATION_MAPPERS = new HashMap<String, List<AnnotationMapper>>();

    protected AbstractAnnotationMetadataBuilder() {
    }

    public AnnotationMetadata build(T element) {
        DefaultAnnotationMetadata annotationMetadata = new DefaultAnnotationMetadata();
        AnnotationMetadata metadata = this.buildInternal(null, element, annotationMetadata, true);
        if (metadata.isEmpty()) {
            return AnnotationMetadata.EMPTY_METADATA;
        }
        return metadata;
    }

    public AnnotationMetadata buildForMethod(T element) {
        DefaultAnnotationMetadata annotationMetadata = new DefaultAnnotationMetadata();
        return this.buildInternal(null, element, annotationMetadata, false);
    }

    public AnnotationMetadata buildForParent(T parent, T element) {
        DefaultAnnotationMetadata annotationMetadata = new DefaultAnnotationMetadata();
        return this.buildInternal(parent, element, annotationMetadata, false);
    }

    protected abstract T getTypeForAnnotation(A var1);

    protected abstract String getAnnotationTypeName(A var1);

    protected abstract List<? extends A> getAnnotationsForType(T var1);

    protected abstract List<T> buildHierarchy(T var1, boolean var2);

    protected abstract void readAnnotationRawValues(String var1, Object var2, Map<CharSequence, Object> var3);

    protected abstract Object readAnnotationValue(String var1, Object var2);

    protected abstract Map<? extends T, ?> readAnnotationDefaultValues(A var1);

    protected abstract Map<? extends T, ?> readAnnotationRawValues(A var1);

    protected abstract OptionalValues<?> getAnnotationValues(T var1, Class<?> var2);

    protected abstract String getAnnotationMemberName(T var1);

    @Nullable
    protected abstract String getRepeatableName(A var1);

    protected AnnotationValue readNestedAnnotationValue(A annotationMirror) {
        AnnotationValue av;
        Map<T, ?> annotationValues = this.readAnnotationRawValues(annotationMirror);
        if (annotationValues.isEmpty()) {
            av = new AnnotationValue(this.getAnnotationTypeName(annotationMirror));
        } else {
            LinkedHashMap<CharSequence, Object> resolvedValues = new LinkedHashMap<CharSequence, Object>();
            for (Map.Entry<T, ?> entry : annotationValues.entrySet()) {
                T member = entry.getKey();
                OptionalValues<AliasFor> aliasForValues = this.getAnnotationValues(member, AliasFor.class);
                Object annotationValue = entry.getValue();
                Optional aliasMember = aliasForValues.get((CharSequence)"member");
                Optional aliasAnnotation = aliasForValues.get((CharSequence)"annotation");
                if (aliasMember.isPresent() && !aliasAnnotation.isPresent()) {
                    String aliasedNamed = aliasMember.get().toString();
                    this.readAnnotationRawValues(aliasedNamed, annotationValue, resolvedValues);
                }
                String memberName = this.getAnnotationMemberName(member);
                this.readAnnotationRawValues(memberName, annotationValue, resolvedValues);
            }
            av = new AnnotationValue(this.getAnnotationTypeName(annotationMirror), resolvedValues);
        }
        return av;
    }

    protected abstract Optional<T> getAnnotationMirror(String var1);

    protected Map<CharSequence, Object> populateAnnotationData(A annotationMirror, DefaultAnnotationMetadata metadata, boolean isDeclared) {
        Map<CharSequence, Object> annotationValues;
        String annotationName = this.getAnnotationTypeName(annotationMirror);
        Map<T, ?> elementDefaultValues = this.readAnnotationDefaultValues(annotationMirror);
        if (elementDefaultValues != null) {
            LinkedHashMap<CharSequence, Object> defaultValues = new LinkedHashMap<CharSequence, Object>();
            for (Map.Entry<T, ?> entry : elementDefaultValues.entrySet()) {
                T t = entry.getKey();
                String memberName = this.getAnnotationMemberName(t);
                if (defaultValues.containsKey(memberName)) continue;
                Object annotationValue = entry.getValue();
                this.readAnnotationRawValues(memberName, annotationValue, defaultValues);
            }
            metadata.addDefaultAnnotationValues(annotationName, defaultValues);
            if (!DefaultAnnotationMetadata.areAnnotationDefaultsRegistered(annotationName)) {
                HashMap<String, Object> annotationDefaults = new HashMap<String, Object>(defaultValues.size());
                for (Map.Entry entry : defaultValues.entrySet()) {
                    annotationDefaults.put(((CharSequence)entry.getKey()).toString(), entry.getValue());
                }
                DefaultAnnotationMetadata.registerAnnotationDefaults(annotationName, annotationDefaults);
            }
        }
        ArrayList<String> parentAnnotations = new ArrayList<String>();
        parentAnnotations.add(annotationName);
        Map<T, ?> elementValues = this.readAnnotationRawValues(annotationMirror);
        if (CollectionUtils.isEmpty(elementValues)) {
            annotationValues = Collections.emptyMap();
        } else {
            annotationValues = new LinkedHashMap();
            for (Map.Entry<T, ?> entry : elementValues.entrySet()) {
                T member = entry.getKey();
                if (member == null) continue;
                Optional aliases = this.getAnnotationValues(member, Aliases.class).get((CharSequence)"value");
                Object annotationValue = entry.getValue();
                if (aliases.isPresent()) {
                    Object value = aliases.get();
                    if (value instanceof AnnotationValue[]) {
                        AnnotationValue[] values;
                        for (AnnotationValue av : values = (AnnotationValue[])value) {
                            OptionalValues aliasForValues = OptionalValues.of(Object.class, (Map)av.getValues());
                            this.processAnnotationAlias(metadata, isDeclared, parentAnnotations, annotationValues, annotationValue, aliasForValues);
                        }
                    }
                    this.readAnnotationRawValues(this.getAnnotationMemberName(member), annotationValue, annotationValues);
                    continue;
                }
                OptionalValues<AliasFor> aliasForValues = this.getAnnotationValues(member, AliasFor.class);
                this.processAnnotationAlias(metadata, isDeclared, parentAnnotations, annotationValues, annotationValue, aliasForValues);
                this.readAnnotationRawValues(this.getAnnotationMemberName(member), annotationValue, annotationValues);
            }
        }
        List<AnnotationMapper> list = ANNOTATION_MAPPERS.get(annotationName);
        if (list != null) {
            AnnotationValue annotationValue = new AnnotationValue(annotationName, annotationValues);
            VisitorContext visitorContext = this.createVisitorContext();
            for (AnnotationMapper mapper : list) {
                List<AnnotationValue<?>> mapped = mapper.map(annotationValue, visitorContext);
                if (mapped == null) continue;
                for (AnnotationValue<?> o : mapped) {
                    if (!(o instanceof AnnotationValue)) continue;
                    AnnotationValue<?> av = o;
                    String mappedAnnotationName = av.getAnnotationName();
                    if (isDeclared) {
                        metadata.addDeclaredAnnotation(mappedAnnotationName, av.getValues());
                    } else {
                        metadata.addAnnotation(mappedAnnotationName, av.getValues());
                    }
                    Optional<Object> mappedMirror = this.getAnnotationMirror(mappedAnnotationName);
                    mappedMirror.ifPresent(annMirror -> this.processAnnotationStereotype(new ArrayList<String>(), annMirror, mappedAnnotationName, metadata, isDeclared));
                }
            }
        }
        return annotationValues;
    }

    protected abstract VisitorContext createVisitorContext();

    private void processAnnotationAlias(DefaultAnnotationMetadata metadata, boolean isDeclared, List<String> parentAnnotations, Map<CharSequence, Object> annotationValues, Object annotationValue, OptionalValues<?> aliasForValues) {
        Optional aliasAnnotation = aliasForValues.get((CharSequence)"annotation");
        Optional aliasMember = aliasForValues.get((CharSequence)"member");
        if (aliasAnnotation.isPresent()) {
            if (aliasMember.isPresent()) {
                String aliasedAnnotationName = aliasAnnotation.get().toString();
                String aliasedMemberName = aliasMember.get().toString();
                Object v = this.readAnnotationValue(aliasedMemberName, annotationValue);
                if (v != null) {
                    Optional<Object> annotationMirror = this.getAnnotationMirror(aliasedAnnotationName);
                    if (isDeclared) {
                        metadata.addDeclaredStereotype(parentAnnotations, aliasedAnnotationName, Collections.singletonMap(aliasedMemberName, v));
                    } else {
                        metadata.addStereotype(parentAnnotations, aliasedAnnotationName, Collections.singletonMap(aliasedMemberName, v));
                    }
                    annotationMirror.ifPresent(annMirror -> this.processAnnotationStereotype(parentAnnotations, annMirror, aliasedAnnotationName, metadata, isDeclared));
                }
            }
        } else if (aliasMember.isPresent()) {
            String aliasedNamed = aliasMember.get().toString();
            Object v = this.readAnnotationValue(aliasedNamed, annotationValue);
            if (v != null) {
                annotationValues.put(aliasedNamed, v);
            }
            this.readAnnotationRawValues(aliasedNamed, annotationValue, annotationValues);
        }
    }

    private AnnotationMetadata buildInternal(T parent, T element, DefaultAnnotationMetadata annotationMetadata, boolean inheritTypeAnnotations) {
        List<T> hierarchy = this.buildHierarchy(element, inheritTypeAnnotations);
        if (parent != null) {
            hierarchy.add(0, parent);
        }
        Collections.reverse(hierarchy);
        for (T currentElement : hierarchy) {
            List<A> annotationHierarchy = this.getAnnotationsForType(currentElement);
            if (annotationHierarchy.isEmpty()) continue;
            boolean isDeclared = currentElement == element;
            for (A annotationMirror : annotationHierarchy) {
                String annotationName = this.getAnnotationTypeName(annotationMirror);
                if (AnnotationUtil.INTERNAL_ANNOTATION_NAMES.contains(annotationName)) continue;
                Map<CharSequence, Object> annotationValues = this.populateAnnotationData(annotationMirror, annotationMetadata, isDeclared);
                String repeatableName = this.getRepeatableName(annotationMirror);
                if (repeatableName != null) {
                    AnnotationValue av = new AnnotationValue(annotationName, annotationValues);
                    if (isDeclared) {
                        annotationMetadata.addDeclaredRepeatable(repeatableName, av);
                        continue;
                    }
                    annotationMetadata.addRepeatable(repeatableName, av);
                    continue;
                }
                if (isDeclared) {
                    annotationMetadata.addDeclaredAnnotation(annotationName, annotationValues);
                    continue;
                }
                annotationMetadata.addAnnotation(annotationName, annotationValues);
            }
            for (A annotationMirror : annotationHierarchy) {
                this.processAnnotationStereotype(annotationMirror, annotationMetadata, isDeclared);
            }
        }
        if (!annotationMetadata.hasDeclaredStereotype(Scope.class) && annotationMetadata.hasDeclaredStereotype(DefaultScope.class)) {
            Optional value = annotationMetadata.getValue(DefaultScope.class, String.class);
            value.ifPresent(name -> annotationMetadata.addDeclaredAnnotation((String)name, Collections.emptyMap()));
        }
        return annotationMetadata;
    }

    private void buildStereotypeHierarchy(List<String> parents, T element, DefaultAnnotationMetadata metadata, boolean isDeclared) {
        List<A> annotationMirrors = this.getAnnotationsForType(element);
        if (!annotationMirrors.isEmpty()) {
            ArrayList<A> topLevel = new ArrayList<A>();
            for (Object annotationMirror : annotationMirrors) {
                String annotationName;
                if (this.getTypeForAnnotation(annotationMirror) == element || AnnotationUtil.INTERNAL_ANNOTATION_NAMES.contains(annotationName = this.getAnnotationTypeName(annotationMirror))) continue;
                topLevel.add(annotationMirror);
                Map<CharSequence, Object> data = this.populateAnnotationData(annotationMirror, metadata, isDeclared);
                String repeatableName = this.getRepeatableName(annotationMirror);
                if (repeatableName != null) {
                    AnnotationValue av = new AnnotationValue(annotationName, data);
                    if (isDeclared) {
                        metadata.addDeclaredRepeatableStereotype(parents, repeatableName, av);
                        continue;
                    }
                    metadata.addRepeatableStereotype(parents, repeatableName, av);
                    continue;
                }
                if (isDeclared) {
                    metadata.addDeclaredStereotype(parents, annotationName, data);
                    continue;
                }
                metadata.addStereotype(parents, annotationName, data);
            }
            for (Object annotationMirror : topLevel) {
                this.processAnnotationStereotype(parents, annotationMirror, metadata, isDeclared);
            }
        }
    }

    private void processAnnotationStereotype(A annotationMirror, DefaultAnnotationMetadata annotationMetadata, boolean isDeclared) {
        String parentAnnotationName = this.getAnnotationTypeName(annotationMirror);
        T annotationType = this.getTypeForAnnotation(annotationMirror);
        ArrayList<String> parentAnnotations = new ArrayList<String>();
        parentAnnotations.add(parentAnnotationName);
        this.buildStereotypeHierarchy(parentAnnotations, annotationType, annotationMetadata, isDeclared);
    }

    private void processAnnotationStereotype(List<String> parents, A annotationMirror, DefaultAnnotationMetadata metadata, boolean isDeclared) {
        T typeForAnnotation = this.getTypeForAnnotation(annotationMirror);
        String annotationTypeName = this.getAnnotationTypeName(annotationMirror);
        this.processAnnotationStereotype(parents, typeForAnnotation, annotationTypeName, metadata, isDeclared);
    }

    private void processAnnotationStereotype(List<String> parents, T annotationType, String annotationTypeName, DefaultAnnotationMetadata metadata, boolean isDeclared) {
        ArrayList<String> stereoTypeParents = new ArrayList<String>(parents);
        stereoTypeParents.add(annotationTypeName);
        this.buildStereotypeHierarchy(stereoTypeParents, annotationType, metadata, isDeclared);
    }

    static {
        SoftServiceLoader serviceLoader = SoftServiceLoader.load(AnnotationMapper.class, (ClassLoader)AbstractAnnotationMetadataBuilder.class.getClassLoader());
        for (ServiceDefinition definition : serviceLoader) {
            if (!definition.isPresent()) continue;
            AnnotationMapper mapper = (AnnotationMapper)definition.load();
            try {
                String name = null;
                if (mapper instanceof TypedAnnotationMapper) {
                    name = ((TypedAnnotationMapper)mapper).annotationType().getName();
                } else if (mapper instanceof NamedAnnotationMapper) {
                    name = ((NamedAnnotationMapper)mapper).getName();
                }
                if (!StringUtils.isNotEmpty((CharSequence)name)) continue;
                ANNOTATION_MAPPERS.computeIfAbsent(name, s -> new ArrayList()).add(mapper);
            }
            catch (Throwable throwable) {}
        }
    }
}

