/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.annotation;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationUtil;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.value.ConvertibleValues;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.inject.annotation.AnnotationMetadataSupport;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;

@Internal
abstract class AbstractAnnotationMetadata
implements AnnotationMetadata {
    protected final Map<String, Annotation> annotationMap;
    protected final Map<String, Annotation> declaredAnnotationMap;
    private Annotation[] allAnnotationArray;
    private Annotation[] declaredAnnotationArray;

    protected AbstractAnnotationMetadata(@Nullable Map<String, Map<CharSequence, Object>> declaredAnnotations, @Nullable Map<String, Map<CharSequence, Object>> allAnnotations) {
        this.declaredAnnotationMap = declaredAnnotations != null ? new ConcurrentHashMap(declaredAnnotations.size()) : null;
        this.annotationMap = allAnnotations != null ? new ConcurrentHashMap(allAnnotations.size()) : null;
    }

    protected AbstractAnnotationMetadata() {
        this.annotationMap = new ConcurrentHashMap<String, Annotation>(2);
        this.declaredAnnotationMap = new ConcurrentHashMap<String, Annotation>(2);
    }

    public <T extends Annotation> T synthesize(Class<T> annotationClass) {
        if (annotationClass == null || this.annotationMap == null) {
            return null;
        }
        if (this.hasAnnotation(annotationClass) || this.hasStereotype(annotationClass)) {
            String annotationName = annotationClass.getName().intern();
            return (T)this.annotationMap.computeIfAbsent(annotationName, s -> {
                ConvertibleValues annotationValues = this.findAnnotation(annotationClass).map(AnnotationValue::getConvertibleValues).orElse(ConvertibleValues.empty());
                return AnnotationMetadataSupport.buildAnnotation(annotationClass, (ConvertibleValues<Object>)annotationValues);
            });
        }
        return null;
    }

    public <T extends Annotation> T synthesizeDeclared(Class<T> annotationClass) {
        if (annotationClass == null || this.declaredAnnotationMap == null) {
            return null;
        }
        String annotationName = annotationClass.getName().intern();
        if (this.hasAnnotation(annotationName) || this.hasStereotype(annotationName)) {
            return (T)this.declaredAnnotationMap.computeIfAbsent(annotationName, s -> {
                ConvertibleValues annotationValues = this.findAnnotation(annotationClass).map(AnnotationValue::getConvertibleValues).orElse(ConvertibleValues.empty());
                return AnnotationMetadataSupport.buildAnnotation(annotationClass, (ConvertibleValues<Object>)annotationValues);
            });
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Annotation[] synthesizeAll() {
        if (this.annotationMap == null) {
            return AnnotationUtil.ZERO_ANNOTATIONS;
        }
        Annotation[] annotations = this.allAnnotationArray;
        if (annotations == null) {
            AbstractAnnotationMetadata abstractAnnotationMetadata = this;
            synchronized (abstractAnnotationMetadata) {
                annotations = this.allAnnotationArray;
                if (annotations == null) {
                    annotations = this.initializeAnnotations(this.getAnnotationNames());
                    this.allAnnotationArray = annotations;
                }
            }
        }
        return annotations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Annotation[] synthesizeDeclared() {
        if (this.declaredAnnotationMap == null) {
            return AnnotationUtil.ZERO_ANNOTATIONS;
        }
        Annotation[] annotations = this.declaredAnnotationArray;
        if (annotations == null) {
            AbstractAnnotationMetadata abstractAnnotationMetadata = this;
            synchronized (abstractAnnotationMetadata) {
                annotations = this.declaredAnnotationArray;
                if (annotations == null) {
                    annotations = this.initializeAnnotations(this.getDeclaredAnnotationNames());
                    this.declaredAnnotationArray = annotations;
                }
            }
        }
        return annotations;
    }

    protected final void addAnnotationValuesFromData(List results, Map<CharSequence, Object> values) {
        block2: {
            Object v;
            block3: {
                AnnotationValue[] avs;
                if (values == null) break block2;
                v = values.get("value");
                if (!(v instanceof AnnotationValue[])) break block3;
                for (AnnotationValue av : avs = (AnnotationValue[])v) {
                    this.addValuesToResults(results, av);
                }
                break block2;
            }
            if (!(v instanceof Collection)) break block2;
            Collection c = (Collection)v;
            for (Object o : c) {
                if (!(o instanceof AnnotationValue)) continue;
                this.addValuesToResults(results, (AnnotationValue)o);
            }
        }
    }

    protected void addValuesToResults(List<AnnotationValue> results, AnnotationValue values) {
        results.add(values);
    }

    private Annotation[] initializeAnnotations(Set<String> names) {
        if (CollectionUtils.isNotEmpty(names)) {
            ArrayList annotations = new ArrayList();
            for (String name : names) {
                Optional loaded = ClassUtils.forName((String)name, (ClassLoader)this.getClass().getClassLoader());
                loaded.ifPresent(aClass -> {
                    Object ann = this.synthesize((Class)aClass);
                    if (ann != null) {
                        annotations.add(ann);
                    }
                });
            }
            return annotations.toArray(new Annotation[annotations.size()]);
        }
        return AnnotationUtil.ZERO_ANNOTATIONS;
    }
}

