/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context.env;

import io.micronaut.context.converters.StringArrayToClassArrayConverter;
import io.micronaut.context.converters.StringToClassConverter;
import io.micronaut.context.env.ComputePlatform;
import io.micronaut.context.env.Environment;
import io.micronaut.context.env.EnvironmentPropertySource;
import io.micronaut.context.env.PropertiesPropertySourceLoader;
import io.micronaut.context.env.PropertyPlaceholderResolver;
import io.micronaut.context.env.PropertySource;
import io.micronaut.context.env.PropertySourceLoader;
import io.micronaut.context.env.PropertySourcePropertyResolver;
import io.micronaut.context.env.SystemPropertiesPropertySource;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.TypeConverter;
import io.micronaut.core.io.ResourceLoader;
import io.micronaut.core.io.ResourceResolver;
import io.micronaut.core.io.file.FileSystemResourceLoader;
import io.micronaut.core.io.scan.CachingClassPathAnnotationScanner;
import io.micronaut.core.io.scan.ClassPathAnnotationScanner;
import io.micronaut.core.io.scan.ClassPathResourceLoader;
import io.micronaut.core.io.service.ServiceDefinition;
import io.micronaut.core.io.service.SoftServiceLoader;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.order.OrderUtil;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.BeanConfiguration;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEnvironment
extends PropertySourcePropertyResolver
implements Environment {
    private static final String EC2_LINUX_HYPERVISOR_FILE = "/sys/hypervisor/uuid";
    private static final String EC2_WINDOWS_HYPERVISOR_CMD = "wmic path win32_computersystemproduct get uuid";
    private static final String FILE_SEPARATOR = ",";
    private static final Logger LOG = LoggerFactory.getLogger(DefaultEnvironment.class);
    private static final String K8S_ENV = "KUBERNETES_SERVICE_HOST";
    private static final String PCF_ENV = "VCAP_SERVICES";
    private static final String HEROKU_DYNO = "DYNO";
    protected final ClassPathResourceLoader resourceLoader;
    private EnvironmentsAndPackage environmentsAndPackage;
    private final Set<String> names;
    private final ClassLoader classLoader;
    private final Collection<String> packages = new ConcurrentLinkedQueue<String>();
    private final ClassPathAnnotationScanner annotationScanner;
    private Collection<String> configurationIncludes = new HashSet<String>();
    private Collection<String> configurationExcludes = new HashSet<String>();
    private final AtomicBoolean running = new AtomicBoolean(false);
    private Collection<PropertySourceLoader> propertySourceLoaderList;
    private final Map<String, PropertySourceLoader> loaderByFormatMap = new ConcurrentHashMap<String, PropertySourceLoader>();
    private final Map<String, Boolean> presenceCache = new ConcurrentHashMap<String, Boolean>();
    private final AtomicBoolean reading = new AtomicBoolean(false);

    public DefaultEnvironment(ClassLoader classLoader, String ... names) {
        this(classLoader, ConversionService.SHARED, names);
    }

    public DefaultEnvironment(String ... names) {
        this(DefaultEnvironment.class.getClassLoader(), ConversionService.SHARED, names);
    }

    public DefaultEnvironment(ClassLoader classLoader, ConversionService conversionService, String ... names) {
        this(ClassPathResourceLoader.defaultLoader((ClassLoader)classLoader), conversionService, names);
    }

    public DefaultEnvironment(ClassPathResourceLoader resourceLoader, ConversionService conversionService, String ... names) {
        super(conversionService);
        LinkedHashSet<String> specifiedNames = new LinkedHashSet<String>(3);
        specifiedNames.addAll(Arrays.asList(names));
        if (!specifiedNames.contains("function") && this.shouldDeduceEnvironments()) {
            EnvironmentsAndPackage environmentsAndPackage = this.getEnvironmentsAndPackage();
            specifiedNames.addAll(environmentsAndPackage.enviroments);
            String aPackage = environmentsAndPackage.aPackage;
            if (aPackage != null) {
                this.packages.add(aPackage);
            }
        }
        this.classLoader = resourceLoader.getClassLoader();
        this.names = specifiedNames;
        conversionService.addConverter(CharSequence.class, Class.class, (TypeConverter)new StringToClassConverter(this.classLoader));
        conversionService.addConverter(Object[].class, Class[].class, (TypeConverter)new StringArrayToClassArrayConverter(conversionService));
        this.resourceLoader = resourceLoader;
        this.annotationScanner = this.createAnnotationScanner(this.classLoader);
    }

    @Override
    public boolean isPresent(String className) {
        return this.presenceCache.computeIfAbsent(className, s -> ClassUtils.isPresent((String)className, (ClassLoader)this.getClassLoader()));
    }

    @Override
    public PropertyPlaceholderResolver getPlaceholderResolver() {
        return this.propertyPlaceholderResolver;
    }

    @Override
    public Stream<Class> scan(Class<? extends Annotation> annotation) {
        return this.annotationScanner.scan(annotation, this.getPackages());
    }

    @Override
    public Stream<Class> scan(Class<? extends Annotation> annotation, String ... packages) {
        return this.annotationScanner.scan(annotation, packages);
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public boolean isActive(BeanConfiguration configuration) {
        String name = configuration.getName();
        return !this.configurationExcludes.contains(name) && (this.configurationIncludes.isEmpty() || this.configurationIncludes.contains(name));
    }

    @Override
    public DefaultEnvironment addPropertySource(PropertySource propertySource) {
        this.propertySources.put(propertySource.getName(), propertySource);
        if (this.isRunning() && !this.reading.get()) {
            this.resetCaches();
            this.processPropertySource(propertySource, PropertySource.PropertyConvention.JAVA_PROPERTIES);
        }
        return this;
    }

    @Override
    public DefaultEnvironment addPropertySource(String name, Map<String, ? super Object> values) {
        return (DefaultEnvironment)super.addPropertySource(name, values);
    }

    @Override
    public Environment addPackage(String pkg) {
        if (!this.packages.contains(pkg)) {
            this.packages.add(pkg);
        }
        return this;
    }

    @Override
    public Environment addConfigurationExcludes(String ... names) {
        if (names != null) {
            this.configurationExcludes.addAll(Arrays.asList(names));
        }
        return this;
    }

    @Override
    public Environment addConfigurationIncludes(String ... names) {
        if (names != null) {
            this.configurationIncludes.addAll(Arrays.asList(names));
        }
        return this;
    }

    @Override
    public Collection<String> getPackages() {
        return Collections.unmodifiableCollection(this.packages);
    }

    @Override
    public Set<String> getActiveNames() {
        return this.names;
    }

    @Override
    public Collection<PropertySource> getPropertySources() {
        return Collections.unmodifiableCollection(this.propertySources.values());
    }

    @Override
    public Environment start() {
        if (this.running.compareAndSet(false, true)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Starting environment {} for active names {}", (Object)this, this.getActiveNames());
            }
            if (this.reading.compareAndSet(false, true)) {
                this.readPropertySources(this.getPropertySourceRootName());
                this.reading.set(false);
            }
        }
        return this;
    }

    @Override
    public boolean isRunning() {
        return this.running.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Environment stop() {
        this.running.set(false);
        this.reading.set(false);
        Map[] mapArray = this.catalog;
        synchronized (this.catalog) {
            for (int i = 0; i < this.catalog.length; ++i) {
                this.catalog[i] = null;
            }
            this.resetCaches();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this;
        }
    }

    @Override
    public Map<String, Object> refreshAndDiff() {
        Map<String, Object>[] copiedCatalog = this.copyCatalog();
        this.refresh();
        return this.diffCatalog(copiedCatalog, this.catalog);
    }

    public <T> Optional<T> convert(Object object, Class<T> targetType, ConversionContext context) {
        return this.conversionService.convert(object, targetType, context);
    }

    public <S, T> boolean canConvert(Class<S> sourceType, Class<T> targetType) {
        return this.conversionService.canConvert(sourceType, targetType);
    }

    public <S, T> Environment addConverter(Class<S> sourceType, Class<T> targetType, TypeConverter<S, T> typeConverter) {
        this.conversionService.addConverter(sourceType, targetType, typeConverter);
        return this;
    }

    public <S, T> Environment addConverter(Class<S> sourceType, Class<T> targetType, Function<S, T> typeConverter) {
        this.conversionService.addConverter(sourceType, targetType, typeConverter);
        return this;
    }

    public Optional<InputStream> getResourceAsStream(String path) {
        return this.resourceLoader.getResourceAsStream(path);
    }

    public Optional<URL> getResource(String path) {
        return this.resourceLoader.getResource(path);
    }

    public Stream<URL> getResources(String path) {
        return this.resourceLoader.getResources(path);
    }

    public boolean supportsPrefix(String path) {
        return this.resourceLoader.supportsPrefix(path);
    }

    public ResourceLoader forBase(String basePath) {
        return this.resourceLoader.forBase(basePath);
    }

    protected boolean shouldDeduceEnvironments() {
        return true;
    }

    protected ClassPathAnnotationScanner createAnnotationScanner(ClassLoader classLoader) {
        return new CachingClassPathAnnotationScanner(classLoader);
    }

    protected String getPropertySourceRootName() {
        return "application";
    }

    protected void readPropertySources(String name) {
        List<PropertySource> propertySources = this.readPropertySourceList(name);
        propertySources.addAll(this.propertySources.values());
        propertySources.addAll(this.readPropertySourceListFromFiles(System.getProperty("micronaut.config.files")));
        propertySources.addAll(this.readPropertySourceListFromFiles(this.readPropertySourceListKeyFromEnvironment()));
        OrderUtil.sort(propertySources);
        for (PropertySource propertySource : propertySources) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Processing property source: {}", (Object)propertySource.getName());
            }
            this.processPropertySource(propertySource, propertySource.getConvention());
        }
    }

    protected String readPropertySourceListKeyFromEnvironment() {
        return System.getenv(StringUtils.convertDotToUnderscore((String)"micronaut.config.files"));
    }

    protected List<PropertySource> readPropertySourceListFromFiles(String files) {
        ArrayList<PropertySource> propertySources = new ArrayList<PropertySource>();
        Collection<PropertySourceLoader> propertySourceLoaders = this.getPropertySourceLoaders();
        Optional<Collection> filePathList = Optional.ofNullable(files).filter(value -> !value.isEmpty()).map(value -> value.split(FILE_SEPARATOR)).map(Arrays::asList).map(Collections::unmodifiableList);
        filePathList.ifPresent(list -> {
            if (!list.isEmpty()) {
                list.forEach(filePath -> {
                    if (!propertySourceLoaders.isEmpty()) {
                        String extension = NameUtils.extension((String)filePath);
                        String fileName = NameUtils.filename((String)filePath);
                        Optional<PropertySourceLoader> propertySourceLoader = Optional.ofNullable(this.loaderByFormatMap.get(extension));
                        if (propertySourceLoader.isPresent()) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("Reading property sources from loader: {}", propertySourceLoader);
                            }
                            this.readPropertySourceFromLoader(fileName, (String)filePath, propertySourceLoader.get(), propertySources);
                        } else {
                            throw new ConfigurationException("Unsupported properties file format: " + fileName);
                        }
                    }
                });
            }
        });
        return propertySources;
    }

    protected List<PropertySource> readPropertySourceList(String name) {
        ArrayList<PropertySource> propertySources = new ArrayList<PropertySource>();
        Collection<PropertySourceLoader> propertySourceLoaders = this.getPropertySourceLoaders();
        if (propertySourceLoaders.isEmpty()) {
            this.loadPropertySourceFromLoader(name, new PropertiesPropertySourceLoader(), propertySources);
        } else {
            for (PropertySourceLoader propertySourceLoader : propertySourceLoaders) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Reading property sources from loader: {}", (Object)propertySourceLoader);
                }
                this.loadPropertySourceFromLoader(name, propertySourceLoader, propertySources);
            }
        }
        if (!this.propertySources.containsKey("system")) {
            propertySources.add(new SystemPropertiesPropertySource());
        }
        if (!this.propertySources.containsKey("env")) {
            propertySources.add(new EnvironmentPropertySource());
        }
        return propertySources;
    }

    protected SoftServiceLoader<PropertySourceLoader> readPropertySourceLoaders() {
        return SoftServiceLoader.load(PropertySourceLoader.class, (ClassLoader)this.getClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<PropertySourceLoader> getPropertySourceLoaders() {
        Collection<PropertySourceLoader> propertySourceLoaderList = this.propertySourceLoaderList;
        if (propertySourceLoaderList == null) {
            DefaultEnvironment defaultEnvironment = this;
            synchronized (defaultEnvironment) {
                propertySourceLoaderList = this.propertySourceLoaderList;
                if (propertySourceLoaderList == null) {
                    this.propertySourceLoaderList = propertySourceLoaderList = this.evaluatePropertySourceLoaders();
                }
            }
        }
        return propertySourceLoaderList;
    }

    private Collection<PropertySourceLoader> evaluatePropertySourceLoaders() {
        SoftServiceLoader<PropertySourceLoader> definitions = this.readPropertySourceLoaders();
        ArrayList<PropertySourceLoader> allLoaders = new ArrayList<PropertySourceLoader>(10);
        for (ServiceDefinition definition : definitions) {
            if (!definition.isPresent()) continue;
            PropertySourceLoader loader = (PropertySourceLoader)definition.load();
            allLoaders.add(loader);
            Set extensions = loader.getExtensions();
            for (String extension : extensions) {
                this.loaderByFormatMap.put(extension, loader);
            }
        }
        return allLoaders;
    }

    private void loadPropertySourceFromLoader(String name, PropertySourceLoader propertySourceLoader, List<PropertySource> propertySources) {
        Optional<PropertySource> defaultPropertySource = propertySourceLoader.load(name, this, null);
        defaultPropertySource.ifPresent(propertySources::add);
        Set<String> activeNames = this.getActiveNames();
        for (String activeName : activeNames) {
            Optional<PropertySource> propertySource = propertySourceLoader.load(name, this, activeName);
            propertySource.ifPresent(propertySources::add);
        }
    }

    private void readPropertySourceFromLoader(String fileName, String filePath, PropertySourceLoader propertySourceLoader, List<PropertySource> propertySources) throws ConfigurationException {
        ResourceResolver resourceResolver = new ResourceResolver();
        Optional resourceLoader = resourceResolver.getSupportingLoader(filePath);
        ResourceLoader loader = (ResourceLoader)resourceLoader.orElse(FileSystemResourceLoader.defaultLoader());
        try {
            Optional inputStream = loader.getResourceAsStream(filePath);
            if (inputStream.isPresent()) {
                Map properties = propertySourceLoader.read(fileName, (InputStream)inputStream.get());
                propertySources.add(PropertySource.of(properties));
            }
        }
        catch (IOException e) {
            throw new ConfigurationException("Unsupported properties file: " + fileName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private EnvironmentsAndPackage getEnvironmentsAndPackage() {
        EnvironmentsAndPackage environmentsAndPackage = this.environmentsAndPackage;
        if (environmentsAndPackage != null) return environmentsAndPackage;
        Class<EnvironmentsAndPackage> clazz = EnvironmentsAndPackage.class;
        synchronized (EnvironmentsAndPackage.class) {
            environmentsAndPackage = this.environmentsAndPackage;
            if (environmentsAndPackage != null) return environmentsAndPackage;
            this.environmentsAndPackage = environmentsAndPackage = DefaultEnvironment.deduceEnvironments();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return environmentsAndPackage;
        }
    }

    private static EnvironmentsAndPackage deduceEnvironments() {
        EnvironmentsAndPackage environmentsAndPackage = new EnvironmentsAndPackage();
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        ListIterator<StackTraceElement> stackTraceIterator = Arrays.asList(stackTrace).listIterator();
        Set<String> environments = environmentsAndPackage.enviroments;
        while (stackTraceIterator.hasNext()) {
            StackTraceElement next;
            StackTraceElement stackTraceElement = stackTraceIterator.next();
            String className = stackTraceElement.getClassName();
            if (className.startsWith("io.micronaut") && stackTraceIterator.hasNext() && !(next = stackTrace[stackTraceIterator.nextIndex()]).getClassName().startsWith("io.micronaut")) {
                environmentsAndPackage.aPackage = NameUtils.getPackageName((String)next.getClassName());
            }
            if (stackTraceElement.getMethodName().contains("$spock_")) {
                environmentsAndPackage.aPackage = NameUtils.getPackageName((String)className);
            }
            if (Stream.of("org.spockframework", "org.junit").anyMatch(className::startsWith)) {
                environments.add("test");
            }
            if (!className.startsWith("com.android")) continue;
            environments.add("android");
        }
        if (!environments.contains("android")) {
            ComputePlatform computePlatform;
            if (StringUtils.isNotEmpty((CharSequence)System.getenv(K8S_ENV))) {
                environments.add("k8s");
                environments.add("cloud");
            }
            if (StringUtils.isNotEmpty((CharSequence)System.getenv(PCF_ENV))) {
                environments.add("pcf");
                environments.add("cloud");
            }
            if (StringUtils.isNotEmpty((CharSequence)System.getenv(HEROKU_DYNO))) {
                environments.add("heroku");
                environments.add("cloud");
            }
            if ((computePlatform = DefaultEnvironment.determineCloudProvider()) != null) {
                switch (computePlatform) {
                    case GOOGLE_COMPUTE: {
                        environments.add("gcp");
                        environments.add("cloud");
                        break;
                    }
                    case AMAZON_EC2: {
                        environments.add("ec2");
                        environments.add("cloud");
                        break;
                    }
                    case AZURE: {
                        environments.add("azure");
                        environments.add("cloud");
                        break;
                    }
                    case IBM: {
                        environments.add("ibm");
                        environments.add("cloud");
                        break;
                    }
                    case OTHER: {
                        break;
                    }
                }
            }
        }
        Stream.of(System.getProperty("micronaut.environments"), System.getenv("MICRONAUT_ENVIRONMENTS")).filter(StringUtils::isNotEmpty).flatMap(s -> Arrays.stream(s.split(FILE_SEPARATOR))).map(String::trim).forEach(environments::add);
        if (LOG.isInfoEnabled() && !environments.isEmpty()) {
            LOG.info("Established active environments: {}", environments);
        }
        return environmentsAndPackage;
    }

    private Map<String, Object> diffCatalog(Map<String, Object>[] original, Map<String, Object>[] newCatalog) {
        LinkedHashMap<String, Object> changes = new LinkedHashMap<String, Object>();
        for (int i = 0; i < original.length; ++i) {
            boolean hasOld;
            Map<String, Object> map = original[i];
            Map<String, Object> newMap = newCatalog[i];
            boolean hasNew = newMap != null;
            boolean bl = hasOld = map != null;
            if (!hasOld && hasNew) {
                changes.putAll(newMap);
                continue;
            }
            if (!hasNew && hasOld) {
                changes.putAll(map);
                continue;
            }
            if (!hasOld || !hasNew) continue;
            this.diffMap(map, newMap, changes);
        }
        return changes;
    }

    private void diffMap(Map<String, Object> map, Map<String, Object> newMap, Map<String, Object> changes) {
        for (Map.Entry<String, Object> entry : newMap.entrySet()) {
            boolean hasOld;
            String key = entry.getKey();
            Object newValue = entry.getValue();
            if (!map.containsKey(key)) {
                changes.put(key, newValue);
                continue;
            }
            Object oldValue = map.get(key);
            boolean hasNew = newValue != null;
            boolean bl = hasOld = oldValue != null;
            if (hasNew && !hasOld) {
                changes.put(key, null);
                continue;
            }
            if (hasOld && !hasNew) {
                changes.put(key, oldValue);
                continue;
            }
            if (!hasNew || !hasOld || newValue.equals(oldValue)) continue;
            changes.put(key, oldValue);
        }
    }

    private Map<String, Object>[] copyCatalog() {
        Map[] newCatalog = new Map[this.catalog.length];
        for (int i = 0; i < this.catalog.length; ++i) {
            Map entry = this.catalog[i];
            if (entry == null) continue;
            newCatalog[i] = new LinkedHashMap(entry);
        }
        return newCatalog;
    }

    private static ComputePlatform determineCloudProvider() {
        if (System.getenv("TRAVIS") != null) {
            return ComputePlatform.OTHER;
        }
        String computePlatform = System.getProperty("micronaut.cloud.platform");
        if (computePlatform != null) {
            try {
                return ComputePlatform.valueOf(computePlatform);
            }
            catch (IllegalArgumentException e) {
                throw new ConfigurationException("Illegal value specified for [micronaut.cloud.platform]: " + computePlatform);
            }
        }
        boolean isWindows = System.getProperty("os.name").toLowerCase().startsWith("windows");
        if (isWindows) {
            if (DefaultEnvironment.isEC2Windows()) {
                return ComputePlatform.AMAZON_EC2;
            }
            if (DefaultEnvironment.isGoogleCompute()) {
                return ComputePlatform.GOOGLE_COMPUTE;
            }
        } else if (DefaultEnvironment.isEC2Linux()) {
            return ComputePlatform.AMAZON_EC2;
        }
        if (DefaultEnvironment.isGoogleCompute()) {
            return ComputePlatform.GOOGLE_COMPUTE;
        }
        return ComputePlatform.BARE_METAL;
    }

    private static boolean isGoogleCompute() {
        try {
            String inputLine;
            URL url = new URL("http://metadata.google.internal");
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setReadTimeout(500);
            con.setConnectTimeout(500);
            con.setRequestMethod("GET");
            con.setDoOutput(true);
            int responseCode = con.getResponseCode();
            BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
            StringBuffer response = new StringBuffer();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            in.close();
            if (con.getHeaderField("Metadata-Flavor") != null && con.getHeaderField("Metadata-Flavor").equalsIgnoreCase("Google")) {
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    private static boolean isEC2Linux() {
        try {
            String contents = new String(Files.readAllBytes(Paths.get(EC2_LINUX_HYPERVISOR_FILE, new String[0])));
            if (contents.startsWith("ec2")) {
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    private static boolean isEC2Windows() {
        try {
            String line;
            ProcessBuilder builder = new ProcessBuilder(new String[0]);
            builder.command("cmd.exe", "/c", EC2_WINDOWS_HYPERVISOR_CMD);
            builder.redirectErrorStream(true);
            builder.directory(new File(System.getProperty("user.home")));
            Process process = builder.start();
            InputStream is = process.getInputStream();
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(isr);
            StringBuilder stdout = new StringBuilder();
            while ((line = br.readLine()) != null) {
                stdout.append(line);
            }
            try {
                int exitValue = process.waitFor();
                if (exitValue == 0 && stdout.toString().startsWith("EC2")) {
                    return true;
                }
            }
            catch (InterruptedException interruptedException) {}
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    private static class EnvironmentsAndPackage {
        String aPackage;
        Set<String> enviroments = new HashSet<String>(1);

        private EnvironmentsAndPackage() {
        }
    }
}

