/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context;

import groovy.lang.GroovySystem;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.BeanContext;
import io.micronaut.context.DefaultBeanContext;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.condition.Condition;
import io.micronaut.context.condition.ConditionContext;
import io.micronaut.context.condition.TrueCondition;
import io.micronaut.context.env.Environment;
import io.micronaut.core.annotation.AnnotationClassValue;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.reflect.ClassLoadingReporter;
import io.micronaut.core.reflect.InstantiationUtils;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.core.value.PropertyResolver;
import io.micronaut.core.version.SemanticVersion;
import io.micronaut.inject.BeanConfiguration;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.BeanDefinitionReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class RequiresCondition
implements Condition {
    private final AnnotationMetadata annotationMetadata;

    public RequiresCondition(AnnotationMetadata annotationMetadata) {
        this.annotationMetadata = annotationMetadata;
    }

    @Override
    public boolean matches(ConditionContext context) {
        block4: {
            Object component = context.getComponent();
            boolean isBeanReference = component instanceof BeanDefinitionReference;
            List requirements = this.annotationMetadata.getAnnotationValuesByType(Requires.class);
            if (requirements.isEmpty()) break block4;
            if (isBeanReference) {
                for (AnnotationValue requirement : requirements) {
                    this.processPreStartRequirements(context, (AnnotationValue<Requires>)requirement);
                    if (!context.isFailing()) continue;
                    return false;
                }
            } else {
                for (AnnotationValue requires : requirements) {
                    this.processPostStartRequirements(context, (AnnotationValue<Requires>)requires);
                    if (!context.isFailing()) continue;
                    return false;
                }
            }
        }
        return true;
    }

    protected boolean matchesConfiguration(ConditionContext context, AnnotationValue<Requires> requirements) {
        String configurationName = requirements.get((CharSequence)"configuration", String.class).orElse(null);
        if (StringUtils.isEmpty((CharSequence)configurationName)) {
            return true;
        }
        BeanContext beanContext = context.getBeanContext();
        String minimumVersion = requirements.get((CharSequence)"version", String.class).orElse(null);
        Optional<BeanConfiguration> beanConfiguration = beanContext.findBeanConfiguration(configurationName);
        if (!beanConfiguration.isPresent()) {
            context.fail("Required configuration [" + configurationName + "] is not active");
            return false;
        }
        String version = beanConfiguration.get().getVersion();
        if (version != null && StringUtils.isNotEmpty((CharSequence)minimumVersion)) {
            boolean result = SemanticVersion.isAtLeast((String)version, (String)minimumVersion);
            context.fail("Required configuration [" + configurationName + "] version requirements not met. Required: " + minimumVersion + ", Current: " + version);
            return result;
        }
        return true;
    }

    private void processPreStartRequirements(ConditionContext context, AnnotationValue<Requires> requirements) {
        if (!this.matchesPresenceOfClasses(context, requirements)) {
            return;
        }
        if (!this.matchesEnvironment(context, requirements)) {
            return;
        }
        if (!this.matchesPresenceOfEntities(context, requirements)) {
            return;
        }
        if (!this.matchesProperty(context, requirements)) {
            return;
        }
        if (!this.matchesMissingProperty(context, requirements)) {
            return;
        }
        if (!this.matchesConfiguration(context, requirements)) {
            return;
        }
        if (!this.matchesSdk(context, requirements)) {
            return;
        }
        this.matchesPresenceOfClasses(context, requirements, "beans");
    }

    private void processPostStartRequirements(ConditionContext context, AnnotationValue<Requires> requirements) {
        this.processPreStartRequirements(context, requirements);
        if (context.isFailing()) {
            return;
        }
        if (!this.matchesPresenceOfBeans(context, requirements)) {
            return;
        }
        if (!this.matchesAbsenceOfBeans(context, requirements)) {
            return;
        }
        this.matchesCustomConditions(context, requirements);
    }

    private boolean matchesProperty(ConditionContext context, AnnotationValue<Requires> requirements) {
        String property = requirements.get((CharSequence)"property", String.class).orElse(null);
        if (StringUtils.isNotEmpty((CharSequence)property)) {
            String value = requirements.get((CharSequence)"value", String.class).orElse(null);
            BeanContext beanContext = context.getBeanContext();
            if (beanContext instanceof PropertyResolver) {
                PropertyResolver propertyResolver = (PropertyResolver)beanContext;
                String notEquals = requirements.get((CharSequence)"notEquals", String.class).orElse(null);
                String defaultValue = requirements.get((CharSequence)"defaultValue", String.class).orElse(null);
                String pattern = requirements.get((CharSequence)"pattern", String.class).orElse(null);
                boolean hasNotEquals = StringUtils.isNotEmpty((CharSequence)notEquals);
                boolean hasPattern = StringUtils.isNotEmpty((CharSequence)pattern);
                if (!propertyResolver.containsProperties(property) && StringUtils.isEmpty((CharSequence)defaultValue)) {
                    if (hasNotEquals) {
                        return true;
                    }
                    context.fail("Required property [" + property + "] not present");
                    return false;
                }
                if (StringUtils.isNotEmpty((CharSequence)value)) {
                    boolean result;
                    String resolved = this.resolvePropertyValue(property, propertyResolver, defaultValue);
                    boolean bl = result = resolved != null && resolved.equals(value);
                    if (!result) {
                        context.fail("Property [" + property + "] with value [" + resolved + "] does not equal required value: " + value);
                    }
                    return result;
                }
                if (hasNotEquals) {
                    boolean result;
                    String resolved = this.resolvePropertyValue(property, propertyResolver, defaultValue);
                    boolean bl = result = resolved == null || !resolved.equals(notEquals);
                    if (!result) {
                        context.fail("Property [" + property + "] with value [" + resolved + "] should not equal: " + notEquals);
                    }
                    return result;
                }
                if (hasPattern) {
                    boolean result;
                    String resolved = this.resolvePropertyValue(property, propertyResolver, defaultValue);
                    boolean bl = result = resolved != null && resolved.matches(pattern);
                    if (!result) {
                        context.fail("Property [" + property + "] with value [" + resolved + "] does not match required pattern: " + pattern);
                    }
                    return result;
                }
            } else {
                context.fail("Bean requires property but BeanContext does not support property resolution");
                return false;
            }
        }
        return true;
    }

    private String resolvePropertyValue(String property, PropertyResolver propertyResolver, String defaultValue) {
        return propertyResolver.getProperty(property, String.class).orElse(defaultValue);
    }

    private boolean matchesMissingProperty(ConditionContext context, AnnotationValue<Requires> requirements) {
        PropertyResolver propertyResolver;
        BeanContext beanContext;
        String property = requirements.get((CharSequence)"missingProperty", String.class).orElse(null);
        if (StringUtils.isNotEmpty((CharSequence)property) && (beanContext = context.getBeanContext()) instanceof PropertyResolver && (propertyResolver = (PropertyResolver)beanContext).containsProperties(property)) {
            context.fail("Property [" + property + "] present");
            return false;
        }
        return true;
    }

    private boolean matchesEnvironment(ConditionContext context, AnnotationValue<Requires> requirements) {
        Object[] env = requirements.get((CharSequence)"env", String[].class).orElse(null);
        if (ArrayUtils.isEmpty((Object[])env)) {
            BeanContext beanContext;
            env = requirements.get((CharSequence)"notEnv", String[].class).orElse(null);
            if (ArrayUtils.isNotEmpty((Object[])env) && (beanContext = context.getBeanContext()) instanceof ApplicationContext) {
                ApplicationContext applicationContext = (ApplicationContext)beanContext;
                Environment environment = applicationContext.getEnvironment();
                Set<String> activeNames = environment.getActiveNames();
                boolean result = Arrays.stream(env).anyMatch(s -> !activeNames.contains(s));
                if (!result) {
                    context.fail("Disallowed environments [" + ArrayUtils.toString((Object[])env) + "] are active: " + activeNames);
                }
                return result;
            }
            return true;
        }
        BeanContext beanContext = context.getBeanContext();
        if (beanContext instanceof ApplicationContext) {
            ApplicationContext applicationContext = (ApplicationContext)beanContext;
            Environment environment = applicationContext.getEnvironment();
            Set<String> activeNames = environment.getActiveNames();
            boolean result = Arrays.stream(env).anyMatch(activeNames::contains);
            if (!result) {
                context.fail("None of the required environments [" + ArrayUtils.toString((Object[])env) + "] are active: " + activeNames);
            }
            return result;
        }
        return true;
    }

    private boolean matchesCustomConditions(ConditionContext context, AnnotationValue<Requires> requirements) {
        Class conditionClass = requirements.get((CharSequence)"condition", Class.class).orElse(null);
        if (conditionClass == TrueCondition.class) {
            return true;
        }
        if (conditionClass != null) {
            Optional condition = InstantiationUtils.tryInstantiate((Class)conditionClass);
            if (condition.isPresent()) {
                boolean conditionResult = ((Condition)condition.get()).matches(context);
                if (!conditionResult) {
                    context.fail("Custom condition [" + conditionClass + "] failed evaluation");
                }
                return conditionResult;
            }
            Optional constructor = ReflectionUtils.findConstructor((Class)conditionClass, (Class[])new Class[]{Object.class, Object.class});
            boolean conditionResult = constructor.flatMap(ctor -> InstantiationUtils.tryInstantiate((Constructor)ctor, (Object[])new Object[]{null, null})).flatMap(obj -> {
                Object result;
                Optional method = ReflectionUtils.findMethod(obj.getClass(), (String)"call", (Class[])new Class[]{ConditionContext.class});
                if (method.isPresent() && (result = ReflectionUtils.invokeMethod((Object)obj, (Method)((Method)method.get()), (Object[])new Object[]{context})) instanceof Boolean) {
                    return Optional.of((Boolean)result);
                }
                return Optional.empty();
            }).orElse(false);
            if (!conditionResult) {
                context.fail("Custom condition [" + conditionClass + "] failed evaluation");
            }
            return conditionResult;
        }
        return !context.isFailing();
    }

    private boolean matchesSdk(ConditionContext context, AnnotationValue<Requires> requirements) {
        Requires.Sdk sdk = requirements.get((CharSequence)"sdk", Requires.Sdk.class).orElse(null);
        String version = requirements.get((CharSequence)"version", String.class).orElse(null);
        if (sdk != null && StringUtils.isNotEmpty((CharSequence)version)) {
            switch (sdk) {
                case GROOVY: {
                    String groovyVersion = GroovySystem.getVersion();
                    boolean versionMatch = SemanticVersion.isAtLeast((String)groovyVersion, (String)version);
                    if (!versionMatch) {
                        context.fail("Groovy version [" + groovyVersion + "] must be at least " + version);
                    }
                    return versionMatch;
                }
                case JAVA: {
                    String javaVersion = System.getProperty("java.version");
                    try {
                        boolean result = SemanticVersion.isAtLeast((String)javaVersion, (String)version);
                        if (!result) {
                            context.fail("Java version [" + javaVersion + "] must be at least " + version);
                        }
                        return result;
                    }
                    catch (Exception e) {
                        char majorVersion = this.resolveJavaMajorVersion(javaVersion);
                        char requiredVersion = this.resolveJavaMajorVersion(version);
                        if (majorVersion >= requiredVersion) {
                            return true;
                        }
                        context.fail("Java major version [" + majorVersion + "] must be at least " + requiredVersion);
                        return context.isFailing();
                    }
                }
            }
            String micronautVersion = this.getClass().getPackage().getImplementationVersion();
            boolean versionCheck = SemanticVersion.isAtLeast((String)micronautVersion, (String)version);
            if (!versionCheck) {
                context.fail("Micronaut version [" + micronautVersion + "] must be at least " + version);
            }
            return versionCheck;
        }
        return true;
    }

    private char resolveJavaMajorVersion(String javaVersion) {
        char majorVersion = '\u0000';
        if (javaVersion.indexOf(46) > -1) {
            String[] tokens = javaVersion.split("\\.");
            majorVersion = tokens[0].charAt(0);
            if (Character.isDigit(majorVersion) && majorVersion == '1' && tokens.length > 1) {
                majorVersion = tokens[1].charAt(0);
            }
        } else {
            char ch = javaVersion.charAt(0);
            if (Character.isDigit(ch)) {
                majorVersion = ch;
            }
        }
        return majorVersion;
    }

    private boolean matchesPresenceOfClasses(ConditionContext context, AnnotationValue<Requires> convertibleValues) {
        return this.matchesPresenceOfClasses(context, convertibleValues, "classes");
    }

    private boolean matchesPresenceOfClasses(ConditionContext context, AnnotationValue<Requires> requirements, String attr) {
        Optional classNames;
        if (requirements.contains(attr) && (classNames = requirements.get((CharSequence)attr, AnnotationClassValue[].class)).isPresent()) {
            AnnotationClassValue[] classValues;
            for (AnnotationClassValue classValue : classValues = (AnnotationClassValue[])classNames.get()) {
                if (classValue.getType().isPresent()) continue;
                context.fail("Class [" + classValue.getName() + "] is not present");
                if (ClassLoadingReporter.isReportingEnabled()) {
                    for (AnnotationClassValue cv : classValues) {
                        ClassLoadingReporter.reportMissing((String)cv.getName());
                    }
                    this.reportMissingClass(context);
                }
                return false;
            }
        }
        return true;
    }

    private void reportMissingClass(ConditionContext context) {
        Object component = context.getComponent();
        if (component instanceof BeanDefinitionReference) {
            ClassLoadingReporter.reportMissing((String)component.getClass().getName());
        }
    }

    private boolean matchesPresenceOfEntities(ConditionContext context, AnnotationValue<Requires> annotationValue) {
        BeanContext beanContext;
        Optional classNames;
        if (annotationValue.contains("entities") && (classNames = annotationValue.get((CharSequence)"entities", AnnotationClassValue[].class)).isPresent() && (beanContext = context.getBeanContext()) instanceof ApplicationContext) {
            AnnotationClassValue[] classValues;
            ApplicationContext applicationContext = (ApplicationContext)beanContext;
            for (AnnotationClassValue classValue : classValues = (AnnotationClassValue[])classNames.get()) {
                Class annotationType;
                Optional entityType = classValue.getType();
                if (!entityType.isPresent()) {
                    context.fail("Annotation type [" + classValue.getName() + "] not present on classpath");
                    return false;
                }
                Environment environment = applicationContext.getEnvironment();
                if (environment.scan(annotationType = (Class)entityType.get()).findFirst().isPresent()) continue;
                context.fail("No entities found in packages [" + String.join((CharSequence)", ", environment.getPackages()) + "] for annotation: " + annotationType);
                return false;
            }
        }
        return true;
    }

    private boolean matchesPresenceOfBeans(ConditionContext context, AnnotationValue<Requires> requirements) {
        Object[] beans = requirements.get((CharSequence)"beans", Class[].class).orElse(null);
        if (ArrayUtils.isNotEmpty((Object[])beans)) {
            BeanContext beanContext = context.getBeanContext();
            for (Object type : beans) {
                if (beanContext.containsBean((Class)type)) continue;
                context.fail("No bean of type [" + type + "] present within context");
                return false;
            }
        }
        return true;
    }

    private boolean matchesAbsenceOfBeans(ConditionContext context, AnnotationValue<Requires> requirements) {
        Object[] missingBeans = requirements.get((CharSequence)"missingBeans", Class[].class).orElse(null);
        Object component = context.getComponent();
        if (ArrayUtils.isNotEmpty((Object[])missingBeans) && component instanceof BeanDefinition) {
            BeanDefinition bd = (BeanDefinition)component;
            DefaultBeanContext beanContext = (DefaultBeanContext)context.getBeanContext();
            for (Object type : missingBeans) {
                ArrayList beanDefinitions = new ArrayList(beanContext.findBeanCandidates(type, bd));
                if (beanDefinitions.isEmpty()) continue;
                beanDefinitions.removeIf(BeanDefinition::isAbstract);
                if (beanDefinitions.isEmpty()) continue;
                BeanDefinition existing = (BeanDefinition)beanDefinitions.iterator().next();
                context.fail("Existing bean [" + existing.getName() + "] of type [" + type + "] registered in context");
                return false;
            }
        }
        return true;
    }
}

