/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context;

import io.micronaut.context.BeanContext;
import io.micronaut.context.DefaultBeanContext;
import io.micronaut.context.annotation.Parallel;
import io.micronaut.context.event.BeanCreatedEvent;
import io.micronaut.context.event.BeanCreatedEventListener;
import io.micronaut.context.processor.ExecutableMethodProcessor;
import io.micronaut.core.async.subscriber.Completable;
import io.micronaut.core.type.Argument;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.inject.qualifiers.Qualifiers;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ForkJoinPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ExecutableMethodProcessorListener
implements BeanCreatedEventListener<ExecutableMethodProcessor> {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultBeanContext.class);

    ExecutableMethodProcessorListener() {
    }

    @Override
    public ExecutableMethodProcessor onCreated(BeanCreatedEvent<ExecutableMethodProcessor> event) {
        ExecutableMethodProcessor processor = (ExecutableMethodProcessor)event.getBean();
        BeanDefinition processorDefinition = event.getBeanDefinition();
        BeanContext beanContext = event.getSource();
        List<Argument<ExecutableMethodProcessor>> typeArguments = processorDefinition.getTypeArguments(ExecutableMethodProcessor.class);
        if (!typeArguments.isEmpty()) {
            Class annotationType = typeArguments.get(0).getType();
            Collection<BeanDefinition<?>> beanDefinitions = beanContext.getBeanDefinitions(Qualifiers.byStereotype(annotationType));
            boolean isParallel = annotationType.isAnnotationPresent(Parallel.class);
            if (isParallel) {
                for (BeanDefinition<?> beanDefinition : beanDefinitions) {
                    Collection<ExecutableMethod<?, ?>> executableMethods = beanDefinition.getExecutableMethods();
                    for (ExecutableMethod<?, ?> executableMethod : executableMethods) {
                        ForkJoinPool.commonPool().execute(() -> {
                            block4: {
                                try {
                                    if (beanContext.isRunning()) {
                                        processor.process(beanDefinition, executableMethod);
                                    }
                                }
                                catch (Throwable e) {
                                    Boolean shutdownOnError;
                                    if (LOG.isErrorEnabled()) {
                                        LOG.error("Error processing bean method " + beanDefinition + "." + executableMethod + " with processor (" + processor + "): " + e.getMessage(), e);
                                    }
                                    if (!(shutdownOnError = executableMethod.getAnnotationMetadata().getValue(Parallel.class, "shutdownOnError", Boolean.class).orElse(true)).booleanValue()) break block4;
                                    beanContext.stop();
                                }
                            }
                        });
                    }
                }
            } else {
                for (BeanDefinition<?> beanDefinition : beanDefinitions) {
                    Collection<ExecutableMethod<?, ?>> executableMethods = beanDefinition.getExecutableMethods();
                    for (ExecutableMethod<?, ?> executableMethod : executableMethods) {
                        processor.process(beanDefinition, executableMethod);
                    }
                }
            }
        }
        if (processor instanceof Completable) {
            ((Completable)processor).onComplete();
        }
        return processor;
    }
}

