/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context;

import io.micronaut.context.Qualifier;
import io.micronaut.core.reflect.InstantiationUtils;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Stream;

public interface BeanLocator {
    public <T> T getBean(Class<T> var1, Qualifier<T> var2);

    public <T> Optional<T> findBean(Class<T> var1, Qualifier<T> var2);

    public <T> Collection<T> getBeansOfType(Class<T> var1);

    public <T> Collection<T> getBeansOfType(Class<T> var1, Qualifier<T> var2);

    public <T> Stream<T> streamOfType(Class<T> var1, Qualifier<T> var2);

    public <T> T getProxyTargetBean(Class<T> var1, Qualifier<T> var2);

    default public <T> Stream<T> streamOfType(Class<T> beanType) {
        return this.streamOfType(beanType, null);
    }

    default public <T> T getBean(Class<T> beanType) {
        return this.getBean(beanType, null);
    }

    default public <T> Optional<T> findBean(Class<T> beanType) {
        return this.findBean(beanType, null);
    }

    default public <T> Optional<T> findOrInstantiateBean(Class<T> beanType) {
        Optional<T> bean = this.findBean(beanType, null);
        if (bean.isPresent()) {
            return bean;
        }
        return InstantiationUtils.tryInstantiate(beanType);
    }
}

