/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context;

import io.micronaut.context.BeanRegistration;
import io.micronaut.context.Qualifier;
import io.micronaut.context.exceptions.NoSuchBeanException;
import io.micronaut.inject.BeanConfiguration;
import io.micronaut.inject.BeanDefinition;
import java.util.Collection;
import java.util.Optional;

public interface BeanDefinitionRegistry {
    public <T> boolean containsBean(Class<T> var1, Qualifier<T> var2);

    public <T> BeanDefinitionRegistry registerSingleton(Class<T> var1, T var2, Qualifier<T> var3, boolean var4);

    public Optional<BeanConfiguration> findBeanConfiguration(String var1);

    public <T> Optional<BeanDefinition<T>> findBeanDefinition(Class<T> var1, Qualifier<T> var2);

    public <T> Optional<BeanRegistration<T>> findBeanRegistration(T var1);

    public <T> Collection<BeanDefinition<T>> getBeanDefinitions(Class<T> var1);

    public <T> Collection<BeanDefinition<T>> getBeanDefinitions(Class<T> var1, Qualifier<T> var2);

    public Collection<BeanDefinition<?>> getBeanDefinitions(Qualifier<Object> var1);

    public Collection<BeanDefinition<?>> getAllBeanDefinitions();

    public Collection<BeanRegistration<?>> getActiveBeanRegistrations(Qualifier<?> var1);

    public <T> Collection<BeanRegistration<T>> getActiveBeanRegistrations(Class<T> var1);

    public <T> Collection<BeanRegistration<T>> getBeanRegistrations(Class<T> var1);

    public <T> Optional<BeanDefinition<T>> findProxyTargetBeanDefinition(Class<T> var1, Qualifier<T> var2);

    public <T> Optional<BeanDefinition<T>> findProxyBeanDefinition(Class<T> var1, Qualifier<T> var2);

    default public <T> BeanDefinitionRegistry registerSingleton(Class<T> type, T singleton, Qualifier<T> qualifier) {
        return this.registerSingleton(type, singleton, qualifier, true);
    }

    default public <T> BeanDefinitionRegistry registerSingleton(Class<T> type, T singleton) {
        return this.registerSingleton(type, singleton, null);
    }

    default public <T> BeanDefinition<T> getBeanDefinition(Class<T> beanType, Qualifier<T> qualifier) {
        return this.findBeanDefinition(beanType, qualifier).orElseThrow(() -> new NoSuchBeanException(beanType, qualifier));
    }

    default public <T> BeanDefinition<T> getProxyTargetBeanDefinition(Class<T> beanType, Qualifier<T> qualifier) {
        return this.findProxyTargetBeanDefinition(beanType, qualifier).orElseThrow(() -> new NoSuchBeanException(beanType, qualifier));
    }

    default public <T> BeanDefinition<T> getBeanDefinition(Class<T> beanType) {
        return this.findBeanDefinition(beanType, null).orElseThrow(() -> new NoSuchBeanException(beanType));
    }

    default public <T> Optional<BeanDefinition<T>> findBeanDefinition(Class<T> beanType) {
        return this.findBeanDefinition(beanType, null);
    }

    default public BeanDefinitionRegistry registerSingleton(Object singleton) {
        Class<?> type = singleton.getClass();
        return this.registerSingleton(type, singleton);
    }

    default public BeanDefinitionRegistry registerSingleton(Object singleton, boolean inject) {
        Class<?> type = singleton.getClass();
        return this.registerSingleton(type, singleton, null, inject);
    }

    default public boolean containsBean(Class beanType) {
        return this.containsBean(beanType, null);
    }
}

