/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context;

import io.micronaut.context.BeanDefinitionRegistry;
import io.micronaut.context.BeanLocator;
import io.micronaut.context.DefaultBeanContext;
import io.micronaut.context.ExecutionHandleLocator;
import io.micronaut.context.LifeCycle;
import io.micronaut.context.Qualifier;
import io.micronaut.context.event.ApplicationEventPublisher;
import io.micronaut.core.annotation.AnnotationMetadataResolver;
import io.micronaut.inject.BeanIdentifier;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;

public interface BeanContext
extends LifeCycle<BeanContext>,
ExecutionHandleLocator,
BeanLocator,
BeanDefinitionRegistry,
ApplicationEventPublisher,
AnnotationMetadataResolver {
    public <T> T inject(T var1);

    default public <T> T createBean(Class<T> beanType) {
        return this.createBean(beanType, (Qualifier)null);
    }

    public <T> T createBean(Class<T> var1, Qualifier<T> var2);

    public <T> T createBean(Class<T> var1, Qualifier<T> var2, Map<String, Object> var3);

    public <T> T createBean(Class<T> var1, Qualifier<T> var2, Object ... var3);

    default public <T> T createBean(Class<T> beanType, Object ... args) {
        return this.createBean(beanType, null, args);
    }

    default public <T> T createBean(Class<T> beanType, Map<String, Object> argumentValues) {
        return this.createBean(beanType, null, argumentValues);
    }

    public <T> T destroyBean(Class<T> var1);

    public <T> Optional<T> refreshBean(BeanIdentifier var1);

    public ClassLoader getClassLoader();

    @Override
    public <T> BeanContext registerSingleton(Class<T> var1, T var2, Qualifier<T> var3, boolean var4);

    @Override
    default public BeanContext registerSingleton(@Nonnull Object singleton) {
        Objects.requireNonNull(singleton, "Argument [singleton] must not be null");
        Class<?> type = singleton.getClass();
        return this.registerSingleton((Class)type, singleton);
    }

    @Override
    default public <T> BeanContext registerSingleton(Class<T> type, T singleton, Qualifier<T> qualifier) {
        return this.registerSingleton((Class)type, (Object)singleton, (Qualifier)qualifier, true);
    }

    @Override
    default public <T> BeanContext registerSingleton(Class<T> type, T singleton) {
        return this.registerSingleton((Class)type, (Object)singleton, (Qualifier)null, true);
    }

    @Override
    default public BeanContext registerSingleton(Object singleton, boolean inject) {
        return (BeanContext)BeanDefinitionRegistry.super.registerSingleton(singleton, inject);
    }

    public static BeanContext run() {
        return (BeanContext)BeanContext.build().start();
    }

    public static BeanContext build() {
        return new DefaultBeanContext();
    }

    public static BeanContext run(ClassLoader classLoader) {
        return (BeanContext)BeanContext.build(classLoader).start();
    }

    public static BeanContext build(ClassLoader classLoader) {
        return new DefaultBeanContext(classLoader);
    }
}

