/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context;

import io.micronaut.context.ApplicationContext;
import io.micronaut.context.LifeCycle;
import io.micronaut.context.env.PropertySource;
import java.util.Map;
import javax.annotation.Nullable;

public interface ApplicationContextBuilder {
    public ApplicationContextBuilder singletons(Object ... var1);

    public ApplicationContextBuilder environments(String ... var1);

    public ApplicationContextBuilder packages(String ... var1);

    public ApplicationContextBuilder properties(@Nullable Map<String, Object> var1);

    public ApplicationContextBuilder propertySources(PropertySource ... var1);

    public ApplicationContextBuilder mainClass(Class var1);

    public ApplicationContextBuilder classLoader(ClassLoader var1);

    public ApplicationContext build();

    public ApplicationContextBuilder include(String ... var1);

    public ApplicationContextBuilder exclude(String ... var1);

    default public ApplicationContext start() {
        return this.build().start();
    }

    default public <T extends AutoCloseable> T run(Class<T> type) {
        LifeCycle lifeCycle;
        ApplicationContext applicationContext = this.start();
        AutoCloseable bean = (AutoCloseable)applicationContext.getBean(type);
        if (bean instanceof LifeCycle && !(lifeCycle = (LifeCycle)bean).isRunning()) {
            lifeCycle.start();
        }
        return (T)bean;
    }
}

