/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty;

import io.micronaut.core.annotation.Internal;
import io.micronaut.http.MediaType;
import io.micronaut.http.server.netty.AbstractHttpContentProcessor;
import io.micronaut.http.server.netty.NettyHttpRequest;
import io.micronaut.http.server.netty.configuration.NettyHttpServerConfiguration;
import io.netty.buffer.ByteBufHolder;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.codec.http.multipart.FileUpload;
import io.netty.handler.codec.http.multipart.HttpData;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import java.nio.charset.Charset;

@Internal
public class FormDataHttpContentProcessor
extends AbstractHttpContentProcessor<HttpData> {
    private final HttpPostRequestDecoder decoder;
    private final boolean enabled;

    FormDataHttpContentProcessor(NettyHttpRequest<?> nettyHttpRequest, NettyHttpServerConfiguration configuration) {
        super(nettyHttpRequest, configuration);
        Charset characterEncoding = nettyHttpRequest.getCharacterEncoding();
        DefaultHttpDataFactory factory = new DefaultHttpDataFactory(configuration.getMultipart().isDisk(), characterEncoding);
        factory.setMaxLimit(configuration.getMultipart().getMaxFileSize());
        this.decoder = new HttpPostRequestDecoder((HttpDataFactory)factory, nettyHttpRequest.getNativeRequest(), characterEncoding);
        this.enabled = nettyHttpRequest.getContentType().map(type -> type.equals((Object)MediaType.APPLICATION_FORM_URLENCODED_TYPE)).orElse(false) != false || configuration.getMultipart().isEnabled();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    protected void onData(ByteBufHolder message) {
        subscriber = this.getSubscriber();
        if (message instanceof HttpContent) {
            try {
                httpContent = (HttpContent)message;
                postRequestDecoder = this.decoder;
                postRequestDecoder.offer(httpContent);
lbl8:
                // 6 sources

                block10: while (postRequestDecoder.hasNext()) {
                    data = postRequestDecoder.next();
                    try {
                        switch (1.$SwitchMap$io$netty$handler$codec$http$multipart$InterfaceHttpData$HttpDataType[data.getHttpDataType().ordinal()]) {
                            case 1: {
                                attribute = (Attribute)data;
                                subscriber.onNext((Object)attribute);
                                ** break;
                            }
                            case 2: {
                                fileUpload = (FileUpload)data;
                                if (!fileUpload.isCompleted()) ** break;
                                subscriber.onNext((Object)fileUpload);
                                ** break;
                            }
                            ** default:
lbl22:
                            // 1 sources

                            continue block10;
                        }
                    }
                    finally {
                        data.release();
                    }
                }
                currentPartialHttpData = postRequestDecoder.currentPartialHttpData();
                if (currentPartialHttpData instanceof HttpData) {
                    subscriber.onNext((Object)((HttpData)currentPartialHttpData));
                }
            }
            catch (HttpPostRequestDecoder.EndOfDataDecoderException httpContent) {
            }
            catch (Throwable e) {
                this.onError(e);
            }
        } else {
            message.release();
        }
    }

    protected void doAfterOnError(Throwable throwable) {
        this.decoder.destroy();
    }

    protected void doAfterComplete() {
        this.decoder.destroy();
    }
}

