/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.grpc.server;

import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.annotation.Secondary;
import io.micronaut.context.event.ApplicationEventPublisher;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.discovery.ServiceInstance;
import io.micronaut.discovery.cloud.ComputeInstanceMetadataResolver;
import io.micronaut.discovery.event.ServiceReadyEvent;
import io.micronaut.discovery.event.ServiceStoppedEvent;
import io.micronaut.discovery.metadata.ServiceInstanceMetadataContributor;
import io.micronaut.grpc.server.GrpcServerConfiguration;
import io.micronaut.grpc.server.GrpcServerInstance;
import io.micronaut.runtime.ApplicationConfiguration;
import io.micronaut.runtime.exceptions.ApplicationStartupException;
import io.micronaut.runtime.server.EmbeddedServer;
import io.micronaut.runtime.server.event.ServerShutdownEvent;
import io.micronaut.runtime.server.event.ServerStartupEvent;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

@Singleton
@Secondary
@Named(value="grpc.server")
@Requirements(value={@Requires(classes={ServerBuilder.class}), @Requires(property="grpc.server.enabled", value="true", defaultValue="true")})
public class GrpcEmbeddedServer
implements EmbeddedServer {
    private final ApplicationContext applicationContext;
    private final ApplicationConfiguration configuration;
    private final Server server;
    private final GrpcServerConfiguration grpcConfiguration;
    private final ApplicationEventPublisher eventPublisher;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final ComputeInstanceMetadataResolver computeInstanceMetadataResolver;
    private final List<ServiceInstanceMetadataContributor> metadataContributors;
    private ServiceInstance serviceInstance;

    @Internal
    GrpcEmbeddedServer(@NonNull ApplicationContext applicationContext, @NonNull ApplicationConfiguration applicationConfiguration, @NonNull GrpcServerConfiguration grpcServerConfiguration, @NonNull ServerBuilder<?> serverBuilder, @NonNull ApplicationEventPublisher eventPublisher, @Nullable ComputeInstanceMetadataResolver computeInstanceMetadataResolver, @Nullable List<ServiceInstanceMetadataContributor> metadataContributors) {
        ArgumentUtils.requireNonNull((String)"applicationContext", (Object)applicationContext);
        ArgumentUtils.requireNonNull((String)"applicationConfiguration", (Object)applicationConfiguration);
        ArgumentUtils.requireNonNull((String)"grpcServerConfiguration", (Object)grpcServerConfiguration);
        this.applicationContext = applicationContext;
        this.configuration = applicationConfiguration;
        this.grpcConfiguration = grpcServerConfiguration;
        this.eventPublisher = eventPublisher;
        this.server = serverBuilder.build();
        this.computeInstanceMetadataResolver = computeInstanceMetadataResolver;
        this.metadataContributors = metadataContributors;
    }

    @NonNull
    public Server getServer() {
        return this.server;
    }

    @NonNull
    public GrpcServerConfiguration getServerConfiguration() {
        return this.grpcConfiguration;
    }

    public int getPort() {
        if (!this.isRunning()) {
            this.start();
        }
        return this.server.getPort();
    }

    public String getHost() {
        return this.grpcConfiguration.getServerHost().orElse("localhost");
    }

    public String getScheme() {
        return this.grpcConfiguration.isSecure() ? "https" : "http";
    }

    public URL getURL() {
        try {
            return this.getURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Invalid Server URI: " + this.getURI());
        }
    }

    public boolean isServer() {
        return true;
    }

    public URI getURI() {
        return URI.create(this.getScheme() + "://" + this.getHost() + ":" + this.getPort());
    }

    public EmbeddedServer start() {
        if (this.running.compareAndSet(false, true)) {
            try {
                this.server.start();
                this.eventPublisher.publishEvent((Object)new ServerStartupEvent((EmbeddedServer)this));
                this.getApplicationConfiguration().getName().ifPresent(id -> {
                    LinkedHashMap<String, String> metadata = new LinkedHashMap<String, String>();
                    if (this.computeInstanceMetadataResolver != null) {
                        Optional cim = this.computeInstanceMetadataResolver.resolve(this.applicationContext.getEnvironment());
                        cim.ifPresent(computeInstanceMetadata -> metadata.putAll(computeInstanceMetadata.getMetadata()));
                    }
                    this.serviceInstance = new GrpcServerInstance(this, (String)id, this.getURI(), (Map<String, String>)metadata, this.metadataContributors, this.grpcConfiguration);
                    this.applicationContext.publishEvent((Object)new ServiceReadyEvent(this.serviceInstance));
                });
            }
            catch (IOException e) {
                throw new ApplicationStartupException("Unable to start GRPC server: " + e.getMessage(), (Throwable)e);
            }
        }
        return this;
    }

    public EmbeddedServer stop() {
        if (this.running.compareAndSet(true, false)) {
            try {
                this.eventPublisher.publishEvent((Object)new ServerShutdownEvent((EmbeddedServer)this));
                if (this.serviceInstance != null) {
                    this.applicationContext.publishEvent((Object)new ServiceStoppedEvent(this.serviceInstance));
                }
            }
            finally {
                this.server.shutdown();
                try {
                    this.server.awaitTermination(this.grpcConfiguration.getAwaitTermination().toMillis(), TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException ignored) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        return this;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public ApplicationConfiguration getApplicationConfiguration() {
        return this.configuration;
    }

    public boolean isRunning() {
        return this.running.get() && !this.server.isTerminated();
    }
}

