/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.gradle.testresources.internal;

import io.micronaut.gradle.testresources.ServerConnectionParametersProvider;
import io.micronaut.gradle.testresources.StartTestResourcesService;
import org.graalvm.buildtools.gradle.dsl.GraalVMExtension;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.Directory;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.TaskProvider;

public final class TestResourcesGraalVM {
    public static final String ENABLED_PROPERTY_NAME = "testresources.native";

    private TestResourcesGraalVM() {
    }

    public static void configure(Project project, Configuration client, TaskProvider<StartTestResourcesService> internalStart) {
        GraalVMExtension graalVMExtension = (GraalVMExtension)project.getExtensions().findByType(GraalVMExtension.class);
        graalVMExtension.getBinaries().all(b -> b.getRuntimeArgs().addAll(internalStart.map(task -> {
            ServerConnectionParametersProvider provider = new ServerConnectionParametersProvider((Provider<Directory>)task.getSettingsDirectory());
            return provider.asArguments();
        })));
        ProviderFactory providers = project.getProviders();
        boolean includeClient = Boolean.TRUE.equals(providers.systemProperty(ENABLED_PROPERTY_NAME).orElse(providers.gradleProperty(ENABLED_PROPERTY_NAME)).map(s -> {
            if (s.isEmpty() || "true".equalsIgnoreCase((String)s)) {
                return "true";
            }
            return "false";
        }).orElse((Object)"false").map(Boolean::parseBoolean).getOrElse((Object)false));
        if (includeClient) {
            Configuration runtimeClasspath = project.getConfigurations().getByName("runtimeOnly");
            runtimeClasspath.extendsFrom(new Configuration[]{client});
        }
    }
}

