/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.gradle.testresources.internal;

import io.micronaut.gradle.PluginsHelper;
import io.micronaut.gradle.aot.AOTExtension;
import io.micronaut.gradle.aot.MicronautAotPlugin;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.provider.MapProperty;

public final class TestResourcesAOT {
    public static void configure(Project project, Configuration client) {
        AOTExtension aot = (AOTExtension)PluginsHelper.findMicronautExtension((Project)project).getExtensions().getByType(AOTExtension.class);
        ConfigurationContainer configurations = project.getConfigurations();
        project.getPluginManager().withPlugin("io.micronaut.minimal.application", unused -> {
            Configuration optimizedRuntimeClasspath = configurations.getByName("optimizedRuntimeClasspath");
            optimizedRuntimeClasspath.extendsFrom(new Configuration[]{client});
        });
        project.afterEvaluate(p -> {
            MapProperty props = aot.getConfigurationProperties();
            if (((Map)props.get()).containsKey("service.types")) {
                props.put((Object)"service.types", (Object)((String)((Map)props.get()).get("service.types") + ",io.micronaut.testresources.core.TestResourcesResolver"));
            } else {
                props.put((Object)"service.types", (Object)Stream.concat(Stream.of("io.micronaut.testresources.core.TestResourcesResolver"), MicronautAotPlugin.SERVICE_TYPES.stream()).collect(Collectors.joining(",")));
            }
        });
    }
}

