/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.gradle.testresources;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.Properties;
import org.gradle.api.file.Directory;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.process.CommandLineArgumentProvider;

public class ServerConnectionParametersProvider
implements CommandLineArgumentProvider {
    private final Provider<Directory> settingsDirectory;

    public ServerConnectionParametersProvider(Provider<Directory> settingsDirectory) {
        this.settingsDirectory = settingsDirectory;
    }

    @Internal
    public Provider<Directory> getSettingsDirectory() {
        return this.settingsDirectory;
    }

    @Input
    public Provider<String> getSettingsDirectoryString() {
        return this.settingsDirectory.map(directory -> directory.getAsFile().getName());
    }

    public Iterable<String> asArguments() {
        Properties props = new Properties();
        File serverConfig = new File(((Directory)this.settingsDirectory.get()).getAsFile(), "test-resources.properties");
        if (serverConfig.exists()) {
            try (FileInputStream in = new FileInputStream(serverConfig);){
                props.load(in);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            return props.keySet().stream().map(key -> "-Dmicronaut.test.resources." + key + "=" + props.getProperty(key.toString())).toList();
        }
        return Collections.emptyList();
    }
}

