/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.gradle.testresources;

import io.micronaut.gradle.MicronautBasePlugin;
import io.micronaut.gradle.MicronautExtension;
import io.micronaut.gradle.PluginsHelper;
import io.micronaut.gradle.testresources.ServerConnectionParametersProvider;
import io.micronaut.gradle.testresources.StartTestResourcesService;
import io.micronaut.gradle.testresources.StopTestResourcesService;
import io.micronaut.gradle.testresources.TestResourcesConfiguration;
import io.micronaut.gradle.testresources.internal.TestResourcesAOT;
import io.micronaut.gradle.testresources.internal.TestResourcesGraalVM;
import io.micronaut.testresources.buildtools.MavenDependency;
import io.micronaut.testresources.buildtools.ModuleIdentifier;
import io.micronaut.testresources.buildtools.ServerUtils;
import io.micronaut.testresources.buildtools.TestResourcesClasspath;
import io.micronaut.testresources.buildtools.VersionInfo;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.api.GradleException;
import org.gradle.api.JavaVersion;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.attributes.Usage;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.plugins.PluginManager;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.ClasspathNormalizer;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.testing.Test;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.session.BuildSessionLifecycleListener;
import org.gradle.process.JavaForkOptions;

public class MicronautTestResourcesPlugin
implements Plugin<Project> {
    public static final String START_TEST_RESOURCES_SERVICE = "startTestResourcesService";
    public static final String START_TEST_RESOURCES_SERVICE_INTERNAL = "internalStartTestResourcesService";
    public static final String STOP_TEST_RESOURCES_SERVICE = "stopTestResourcesService";
    public static final String GROUP = "Micronaut Test Resources";
    public static final String TESTRESOURCES_CONFIGURATION = "testResourcesService";
    public static final String TESTRESOURCES_ELEMENTS_CONFIGURATION = "testresourcesSettingsElements";
    public static final String MICRONAUT_TEST_RESOURCES_USAGE = "micronaut.test.resources";
    private static final int DEFAULT_CLIENT_TIMEOUT_SECONDS = 60;
    private static final String IDEA_RUN_TASK_SUFFIX = ".main()";

    private static Configuration createTestResourcesClientConfiguration(Project project, TestResourcesConfiguration config) {
        Configuration client = (Configuration)project.getConfigurations().create("testResourcesClient", conf -> {
            conf.setCanBeConsumed(false);
            conf.setCanBeResolved(false);
            conf.setDescription("The Micronaut Test Resources client dependencies");
        });
        DependencyHandler dependencies = project.getDependencies();
        client.getDependencies().addAllLater(config.getVersion().map(v -> {
            if (Boolean.TRUE.equals(config.getEnabled().get())) {
                return Collections.singleton(dependencies.create((Object)("io.micronaut.testresources:micronaut-test-resources-client:" + v)));
            }
            return Collections.emptyList();
        }));
        return client;
    }

    public void apply(Project project) {
        PluginManager pluginManager = project.getPluginManager();
        pluginManager.apply(JavaPlugin.class);
        pluginManager.apply(MicronautBasePlugin.class);
        this.configurePlugin(project);
    }

    private void configurePlugin(Project project) {
        Configuration server = MicronautTestResourcesPlugin.createTestResourcesServerConfiguration(project);
        Configuration outgoing = MicronautTestResourcesPlugin.createTestResourcesOutgoingConfiguration(project);
        ProviderFactory providers = project.getProviders();
        Provider explicitPort = providers.systemProperty("micronaut.test-resources.server.port").map(Integer::parseInt);
        TestResourcesConfiguration config = this.createTestResourcesConfiguration(project, (Provider<Integer>)explicitPort);
        JavaPluginExtension javaPluginExtension = PluginsHelper.javaPluginExtensionOf((Project)project);
        SourceSet testResourcesSourceSet = this.createTestResourcesSourceSet(javaPluginExtension);
        DependencyHandler dependencies = project.getDependencies();
        Configuration testResourcesCompileOnly = project.getConfigurations().getByName(testResourcesSourceSet.getCompileOnlyConfigurationName());
        Configuration testResourcesApi = project.getConfigurations().getByName(testResourcesSourceSet.getImplementationConfigurationName());
        testResourcesCompileOnly.getDependencies().addLater(config.getVersion().map(v -> dependencies.create((Object)("io.micronaut.testresources:micronaut-test-resources-server:" + v))));
        testResourcesApi.getDependencies().addLater(config.getVersion().map(v -> dependencies.create((Object)("io.micronaut.testresources:micronaut-test-resources-core:" + v))));
        server.getDependencies().addAllLater(this.buildTestResourcesDependencyList(project, dependencies, config, testResourcesSourceSet));
        String accessToken = UUID.randomUUID().toString();
        Provider accessTokenProvider = providers.provider(() -> accessToken);
        DirectoryProperty buildDirectory = project.getLayout().getBuildDirectory();
        File testResourcesDir = new File(project.getProjectDir(), ".micronaut/test-resources");
        Provider settingsDirectory = config.getSharedServer().flatMap(shared -> {
            DirectoryProperty directoryProperty = project.getObjects().directoryProperty();
            if (Boolean.TRUE.equals(shared)) {
                String namespace = (String)config.getSharedServerNamespace().getOrNull();
                directoryProperty.set(ServerUtils.getDefaultSharedSettingsPath((String)namespace).toFile());
            }
            return directoryProperty;
        }).orElse((Provider)project.getObjects().directoryProperty().fileValue(new File(testResourcesDir, "test-resources-settings")));
        File portFile = new File(testResourcesDir, "test-resources-port.txt");
        Path stopAtEndFile = this.createStopFile(project);
        TaskContainer tasks = project.getTasks();
        Provider isStandalone = config.getSharedServer().zip(providers.provider(() -> {
            boolean singleTask = project.getGradle().getStartParameter().getTaskNames().size() == 1;
            boolean onlyStartTask = project.getGradle().getTaskGraph().getAllTasks().stream().anyMatch(task -> task.getProject().equals(project) && task.getName().equals(START_TEST_RESOURCES_SERVICE));
            return singleTask && onlyStartTask;
        }), (shared, singleTask) -> shared != false || singleTask != false);
        Provider cdsDir = buildDirectory.dir("test-resources/cds");
        TaskProvider<StartTestResourcesService> internalStart = this.createStartServiceTask(server, config, (Provider<Directory>)settingsDirectory, (Provider<String>)accessTokenProvider, tasks, portFile, stopAtEndFile, (Provider<Boolean>)isStandalone, (Provider<Directory>)cdsDir);
        tasks.register(START_TEST_RESOURCES_SERVICE, task -> {
            task.dependsOn(new Object[]{internalStart});
            task.setOnlyIf(t -> (Boolean)config.getEnabled().get());
            task.setGroup(GROUP);
            task.setDescription("Starts the test resources server in standalone mode");
        });
        this.createStopServiceTask((Provider<Directory>)settingsDirectory, tasks);
        Configuration client = MicronautTestResourcesPlugin.createTestResourcesClientConfiguration(project, config);
        project.afterEvaluate(p -> p.getConfigurations().all(conf -> this.configureDependencies((Configuration)conf, client)));
        outgoing.getOutgoing().artifact(internalStart);
        outgoing.extendsFrom(new Configuration[]{client});
        PluginManager pluginManager = project.getPluginManager();
        pluginManager.withPlugin("org.graalvm.buildtools.native", unused -> TestResourcesGraalVM.configure(project, client, internalStart));
        pluginManager.withPlugin("io.micronaut.aot", unused -> TestResourcesAOT.configure(project, client));
        this.configureServiceReset((ProjectInternal)project, (Provider<Directory>)settingsDirectory, stopAtEndFile);
        tasks.withType(Test.class).configureEach(task -> MicronautTestResourcesPlugin.configureServerConnection(internalStart, (Task)task, config, testResourcesSourceSet));
        tasks.withType(JavaExec.class).configureEach(task -> MicronautTestResourcesPlugin.configureServerConnection(internalStart, (Task)task, config, testResourcesSourceSet));
        MicronautTestResourcesPlugin.workaroundForIntellij(project);
    }

    private static void configureServerConnection(TaskProvider<StartTestResourcesService> internalStart, Task task, TestResourcesConfiguration configuration, SourceSet testResourcesSourceSet) {
        task.dependsOn(new Object[]{internalStart});
        task.getInputs().files(new Object[]{configuration.getEnabled().map(enabled -> {
            if (enabled.booleanValue()) {
                return testResourcesSourceSet.getRuntimeClasspath();
            }
            return Collections.emptyList();
        })}).withPropertyName("inputTestResourcesRuntimeClasspath").withNormalizer(ClasspathNormalizer.class);
        Provider settingsDirectory = internalStart.flatMap(StartTestResourcesService::getSettingsDirectory);
        if (task instanceof JavaForkOptions) {
            JavaForkOptions jfo = (JavaForkOptions)task;
            jfo.getJvmArgumentProviders().add(new ServerConnectionParametersProvider((Provider<Directory>)settingsDirectory));
        }
    }

    private static void workaroundForIntellij(Project project) {
        project.afterEvaluate(unused -> project.getTasks().withType(JavaExec.class).configureEach(javaExec -> {
            if (javaExec.getName().endsWith(IDEA_RUN_TASK_SUFFIX)) {
                javaExec.setClasspath(javaExec.getClasspath().plus((FileCollection)project.getConfigurations().getByName("developmentOnly")));
            }
        }));
    }

    private Path createStopFile(Project project) {
        Path stopAtEndFile;
        try {
            File asFile = ((RegularFile)project.getLayout().getBuildDirectory().file("test-resources/" + UUID.randomUUID()).get()).getAsFile();
            File parentDir = asFile.getParentFile();
            if (!parentDir.isDirectory() && !parentDir.mkdirs()) {
                throw new IOException("Could not create directory for test resources stop file at " + parentDir.getAbsolutePath());
            }
            asFile.deleteOnExit();
            stopAtEndFile = asFile.toPath();
            Files.deleteIfExists(stopAtEndFile);
        }
        catch (IOException e) {
            throw new GradleException("Unable to create temp file", (Throwable)e);
        }
        return stopAtEndFile;
    }

    private SourceSet createTestResourcesSourceSet(JavaPluginExtension javaPluginExtension) {
        return (SourceSet)javaPluginExtension.getSourceSets().create("testResources");
    }

    private void createStopServiceTask(Provider<Directory> settingsDirectory, TaskContainer tasks) {
        tasks.register(STOP_TEST_RESOURCES_SERVICE, StopTestResourcesService.class, task -> task.getSettingsDirectory().convention(settingsDirectory));
    }

    private void configureDependencies(Configuration conf, Configuration client) {
        String name = conf.getName();
        if ("developmentOnly".equals(name) || "testRuntimeOnly".equals(name)) {
            conf.extendsFrom(new Configuration[]{client});
        }
    }

    private TaskProvider<StartTestResourcesService> createStartServiceTask(Configuration server, TestResourcesConfiguration config, Provider<Directory> settingsDirectory, Provider<String> accessToken, TaskContainer tasks, File portFile, Path stopFile, Provider<Boolean> isStandalone, Provider<Directory> cdsDir) {
        return tasks.register(START_TEST_RESOURCES_SERVICE_INTERNAL, StartTestResourcesService.class, task -> {
            task.setOnlyIf(t -> (Boolean)config.getEnabled().get());
            task.getPortFile().set(portFile);
            task.getSettingsDirectory().convention(settingsDirectory);
            task.getAccessToken().convention(accessToken);
            task.getExplicitPort().convention(config.getExplicitPort());
            task.getClientTimeout().convention(config.getClientTimeout());
            task.getServerIdleTimeoutMinutes().convention(config.getServerIdleTimeoutMinutes());
            task.getClasspath().from(new Object[]{server.getIncoming().artifactView(view -> view.componentFilter(id -> {
                if (id instanceof ModuleComponentIdentifier) {
                    ModuleComponentIdentifier mci = (ModuleComponentIdentifier)id;
                    return TestResourcesClasspath.isDependencyAllowedOnServerClasspath((ModuleIdentifier)new ModuleIdentifier(mci.getGroup(), mci.getModule()));
                }
                return true;
            })).getFiles()});
            task.getForeground().convention((Object)false);
            task.getStopFile().set(stopFile.toFile());
            task.getStandalone().set(isStandalone);
            task.getClassDataSharingDir().convention(cdsDir);
            task.getUseClassDataSharing().convention((Object)JavaVersion.current().isCompatibleWith(JavaVersion.VERSION_17));
        });
    }

    private TestResourcesConfiguration createTestResourcesConfiguration(Project project, Provider<Integer> explicitPort) {
        MicronautExtension micronautExtension = PluginsHelper.findMicronautExtension((Project)project);
        TestResourcesConfiguration testResources = (TestResourcesConfiguration)micronautExtension.getExtensions().create("testResources", TestResourcesConfiguration.class, new Object[0]);
        ProviderFactory providers = project.getProviders();
        testResources.getEnabled().convention((Object)true);
        testResources.getVersion().convention((Object)VersionInfo.getVersion());
        testResources.getExplicitPort().convention(explicitPort);
        testResources.getInferClasspath().convention((Object)true);
        testResources.getClientTimeout().convention((Object)60);
        testResources.getSharedServer().convention(providers.gradleProperty("shared.test.resources").orElse(providers.systemProperty("shared.test.resources")).orElse(providers.environmentVariable("SHARED_TEST_RESOURCES")).orElse((Object)"false").map(str -> {
            if (str.isEmpty()) {
                return true;
            }
            return Boolean.parseBoolean(str);
        }));
        testResources.getSharedServerNamespace().convention(providers.environmentVariable("SHARED_TEST_RESOURCES_NAMESPACE"));
        return testResources;
    }

    private Provider<List<Dependency>> buildTestResourcesDependencyList(Project project, DependencyHandler dependencies, TestResourcesConfiguration config, SourceSet testResourcesSourceSet) {
        return config.getEnabled().zip(config.getInferClasspath(), (enabled, infer) -> {
            if (Boolean.FALSE.equals(enabled)) {
                return Collections.singletonList(dependencies.create((Object)testResourcesSourceSet.getRuntimeClasspath()));
            }
            List<Object> mavenDependencies = Collections.emptyList();
            if (Boolean.TRUE.equals(infer)) {
                mavenDependencies = project.getConfigurations().getByName("runtimeClasspath").getAllDependencies().stream().filter(ModuleDependency.class::isInstance).map(ModuleDependency.class::cast).map(d -> new MavenDependency(d.getGroup(), d.getName(), d.getVersion())).toList();
            }
            String testResourcesVersion = (String)config.getVersion().get();
            MicronautTestResourcesPlugin.assertMinimalVersion(testResourcesVersion);
            return Stream.concat(Stream.concat(TestResourcesClasspath.inferTestResourcesClasspath(mavenDependencies, (String)testResourcesVersion).stream().map(Object::toString), ((List)config.getAdditionalModules().getOrElse(Collections.emptyList())).stream().map(m -> "io.micronaut.testresources:micronaut-test-resources-" + m + ":" + testResourcesVersion)).map(arg_0 -> ((DependencyHandler)dependencies).create(arg_0)), Stream.of(dependencies.create((Object)testResourcesSourceSet.getRuntimeClasspath()))).toList();
        }).orElse(Collections.emptyList());
    }

    private static void assertMinimalVersion(String testedVersion) {
        ArrayList<Integer> testedVersionParts = MicronautTestResourcesPlugin.parseVersion(testedVersion);
        ArrayList<Integer> minimalVersionParts = MicronautTestResourcesPlugin.parseVersion(VersionInfo.getVersion());
        while (minimalVersionParts.size() < testedVersionParts.size()) {
            minimalVersionParts.add(0);
        }
        for (int i = 0; i < testedVersionParts.size(); ++i) {
            int reference;
            int tested = (Integer)testedVersionParts.get(i);
            if (tested < (reference = ((Integer)minimalVersionParts.get(i)).intValue())) {
                throw new GradleException("Micronaut Test Resources version " + testedVersion + " is not compatible with this Micronaut Gradle Plugin version. Please use at least release " + VersionInfo.getVersion());
            }
            if (tested > reference) break;
        }
    }

    static ArrayList<Integer> parseVersion(String testedVersion) {
        String version = testedVersion;
        int index = version.indexOf(45);
        if (index > 0) {
            version = version.substring(0, index);
        }
        return Arrays.stream(version.split("\\.")).map(String::trim).map(s -> s.replaceAll("\\D", "")).map(Integer::parseInt).collect(Collectors.toCollection(ArrayList::new));
    }

    private void configureServiceReset(final ProjectInternal project, final Provider<Directory> settingsDirectory, final Path shouldStopFile) {
        ServiceRegistry services = project.getServices();
        ListenerManager listenerManager = (ListenerManager)services.get(ListenerManager.class);
        try {
            Field parentField = listenerManager.getClass().getDeclaredField("parent");
            parentField.setAccessible(true);
            listenerManager = (ListenerManager)parentField.get(parentField.get(listenerManager));
            listenerManager.addListener((Object)new BuildSessionLifecycleListener(){

                public void beforeComplete() {
                    try {
                        if (Files.exists(shouldStopFile, new LinkOption[0])) {
                            if (project.getLogger().isDebugEnabled()) {
                                project.getLogger().debug("Stop file contains {}", Files.readAllLines(shouldStopFile));
                            }
                            if (Boolean.parseBoolean(Files.readAllLines(shouldStopFile).get(0))) {
                                ServerUtils.stopServer((Path)((Directory)settingsDirectory.get()).getAsFile().toPath());
                            }
                        }
                    }
                    catch (IOException e) {
                        project.getLogger().debug("Test resources server is already stopped", (Throwable)e);
                    }
                }
            });
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new GradleException(e.getMessage(), (Throwable)e);
        }
    }

    private static Configuration createTestResourcesServerConfiguration(Project project) {
        ConfigurationContainer configurations = project.getConfigurations();
        Configuration boms = (Configuration)configurations.findByName("micronautBoms");
        PluginsHelper.maybeAddMicronautPlaformBom((Project)project, (Configuration)boms);
        return (Configuration)configurations.create(TESTRESOURCES_CONFIGURATION, conf -> {
            conf.extendsFrom(new Configuration[]{boms});
            conf.setDescription("Dependencies for the Micronaut test resources service");
            conf.setCanBeConsumed(false);
            conf.setCanBeResolved(true);
        });
    }

    private static Configuration createTestResourcesOutgoingConfiguration(Project project) {
        return (Configuration)project.getConfigurations().create(TESTRESOURCES_ELEMENTS_CONFIGURATION, conf -> {
            conf.setDescription("Provides the Micronaut Test Resources client configuration files");
            conf.setCanBeConsumed(true);
            conf.setCanBeResolved(false);
            conf.attributes(attr -> attr.attribute(Usage.USAGE_ATTRIBUTE, (Object)((Usage)project.getObjects().named(Usage.class, MICRONAUT_TEST_RESOURCES_USAGE))));
        });
    }
}

