/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.gradle.testresources;

import io.micronaut.testresources.buildtools.ServerFactory;
import io.micronaut.testresources.buildtools.ServerUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;
import org.gradle.process.ExecOperations;
import org.gradle.process.JavaExecSpec;
import org.gradle.work.Incremental;

public abstract class StartTestResourcesService
extends DefaultTask {
    @InputFiles
    @Classpath
    @Incremental
    abstract ConfigurableFileCollection getClasspath();

    @OutputDirectory
    abstract DirectoryProperty getSettingsDirectory();

    @Internal
    abstract RegularFileProperty getPortFile();

    @Input
    @Optional
    abstract Property<Integer> getExplicitPort();

    @Input
    @Optional
    abstract Property<String> getAccessToken();

    @Input
    @Optional
    abstract Property<Integer> getClientTimeout();

    @Internal
    @Option(option="block", description="Runs the test server in foreground, blocking until the server is stopped.")
    abstract Property<Boolean> getForeground();

    @Internal
    abstract RegularFileProperty getStopFile();

    @Internal
    abstract Property<Boolean> getDebugServer();

    @Internal
    abstract Property<Boolean> getStandalone();

    @Internal
    abstract Property<Boolean> getUseClassDataSharing();

    @Internal
    abstract DirectoryProperty getClassDataSharingDir();

    @Inject
    protected abstract ExecOperations getExecOperations();

    @Inject
    protected abstract ObjectFactory getObjects();

    @Inject
    public StartTestResourcesService() {
        this.setGroup("Micronaut Test Resources");
        this.setDescription("Starts the test resources server");
    }

    @TaskAction
    public void startService() throws IOException {
        Path cdsDir = null;
        if (((Boolean)this.getUseClassDataSharing().get()).booleanValue()) {
            cdsDir = ((Directory)this.getClassDataSharingDir().get()).getAsFile().toPath();
        }
        ServerFactory serverFactory = new ServerFactory(){

            public void startServer(ServerUtils.ProcessParameters processParameters) throws IOException {
                Path stopFilePath = ((File)StartTestResourcesService.this.getStopFile().getAsFile().get()).toPath();
                if (!Files.exists(stopFilePath, new LinkOption[0])) {
                    if (Boolean.TRUE.equals(StartTestResourcesService.this.getStandalone().get())) {
                        StartTestResourcesService.this.getLogger().lifecycle("Test resources server started in standalone mode. You can stop it by running the stopTestResourcesService task.");
                    }
                    String stop = (String)StartTestResourcesService.this.getStandalone().map(v -> String.valueOf(v == false)).get();
                    Files.createDirectories(stopFilePath.getParent(), new FileAttribute[0]);
                    Files.write(stopFilePath, Collections.singletonList(stop), StandardOpenOption.CREATE);
                }
                if (Boolean.TRUE.equals(StartTestResourcesService.this.getForeground().get()) || processParameters.isCDSDumpInvocation()) {
                    this.startService(processParameters);
                } else {
                    new Thread(() -> this.startService(processParameters)).start();
                }
            }

            private void startService(ServerUtils.ProcessParameters processParameters) {
                try {
                    StartTestResourcesService.this.getExecOperations().javaexec(spec -> {
                        spec.getMainClass().set((Object)processParameters.getMainClass());
                        spec.setDebug(((Boolean)StartTestResourcesService.this.getDebugServer().getOrElse((Object)false)).booleanValue());
                        List classpath = processParameters.getClasspath();
                        spec.setClasspath((FileCollection)StartTestResourcesService.this.getObjects().fileCollection().from(new Object[]{classpath}));
                        spec.setJvmArgs(processParameters.getJvmArguments());
                        processParameters.getSystemProperties().forEach((arg_0, arg_1) -> ((JavaExecSpec)spec).systemProperty(arg_0, arg_1));
                        processParameters.getArguments().forEach(xva$0 -> spec.args(new Object[]{xva$0}));
                    });
                }
                catch (GradleException e) {
                    StartTestResourcesService.this.getLogger().info("Test server stopped");
                }
            }

            public void waitFor(Duration duration) throws InterruptedException {
                Thread.sleep(duration.toMillis());
            }
        };
        ServerUtils.startOrConnectToExistingServer((Integer)((Integer)this.getExplicitPort().getOrNull()), (Path)((Path)this.getPortFile().map(f -> f.getAsFile().toPath()).getOrNull()), (Path)((Directory)this.getSettingsDirectory().get()).getAsFile().toPath(), (String)((String)this.getAccessToken().getOrNull()), (Path)cdsDir, (Collection)this.getClasspath().getFiles(), (Integer)((Integer)this.getClientTimeout().getOrNull()), (ServerFactory)serverFactory);
    }
}

