/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.gradle.testresources.internal;

import io.micronaut.gradle.PluginsHelper;
import io.micronaut.gradle.aot.AOTExtension;
import io.micronaut.gradle.aot.MicronautAotPlugin;
import io.micronaut.gradle.testresources.MicronautTestResourcesPlugin;
import io.micronaut.gradle.testresources.StartTestResourcesService;
import io.micronaut.gradle.testresources.TestResourcesConfiguration;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;

public final class TestResourcesAOT {
    public static void configure(Project project, TestResourcesConfiguration config, DependencyHandler dependencies, TaskContainer tasks, TaskProvider<StartTestResourcesService> internalStart, Configuration testResourcesClasspathConfig) {
        AOTExtension aot = (AOTExtension)PluginsHelper.findMicronautExtension((Project)project).getExtensions().getByType(AOTExtension.class);
        Configuration aotAppClasspath = project.getConfigurations().getByName("aotApplicationClasspath");
        MicronautTestResourcesPlugin.addTestResourcesClientDependencies(project, config, dependencies, internalStart, aotAppClasspath);
        project.afterEvaluate(p -> {
            MapProperty props = aot.getConfigurationProperties();
            if (((Map)props.get()).containsKey("service.types")) {
                props.put((Object)"service.types", (Object)((String)((Map)props.get()).get("service.types") + ",io.micronaut.testresources.core.TestResourcesResolver"));
            } else {
                props.put((Object)"service.types", (Object)Stream.concat(Stream.of("io.micronaut.testresources.core.TestResourcesResolver"), MicronautAotPlugin.SERVICE_TYPES.stream()).collect(Collectors.joining(",")));
            }
            tasks.named("optimizedRun", JavaExec.class, javaExec -> javaExec.setClasspath(javaExec.getClasspath().plus((FileCollection)testResourcesClasspathConfig)));
        });
    }
}

