/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.gradle.testresources;

import io.micronaut.gradle.MicronautBasePlugin;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.Usage;
import org.gradle.api.plugins.PluginManager;

public class MicronautTestResourcesConsumerPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        PluginManager pluginManager = project.getPluginManager();
        pluginManager.apply(MicronautBasePlugin.class);
        Configuration testResourcesConfiguration = this.createTestResourcesExtension(project);
        pluginManager.withPlugin("io.micronaut.component", unused -> project.afterEvaluate(p -> p.getConfigurations().all(cnf -> this.configureDependencies(testResourcesConfiguration, (Configuration)cnf))));
    }

    private Configuration createTestResourcesExtension(Project project) {
        Configuration legacyConf = (Configuration)project.getConfigurations().create("testresources", conf -> {
            conf.setCanBeConsumed(false);
            conf.setCanBeResolved(false);
            conf.setDescription("[deprecated] Please use testResourcesService instead.");
        });
        return (Configuration)project.getConfigurations().create("testResourcesService", conf -> {
            conf.extendsFrom(new Configuration[]{legacyConf});
            conf.setCanBeConsumed(false);
            conf.setCanBeResolved(false);
            conf.setDescription("Used to declare projects which provide test resources");
            conf.getDependencies().whenObjectAdded(dep -> {
                if (!(dep instanceof ProjectDependency)) {
                    throw new InvalidUserDataException("The test resources configuration can only contain project dependencies");
                }
                ProjectDependency projectDependency = (ProjectDependency)dep;
                projectDependency.attributes(attrs -> MicronautTestResourcesConsumerPlugin.configureUsageAttribute(project, attrs));
            });
        });
    }

    private static AttributeContainer configureUsageAttribute(Project project, AttributeContainer attrs) {
        return attrs.attribute(Usage.USAGE_ATTRIBUTE, (Object)project.getObjects().named(Usage.class, "micronaut.test.resources"));
    }

    private void configureDependencies(Configuration config, Configuration conf) {
        String name = conf.getName();
        if ("developmentOnly".equals(name) || "testRuntimeOnly".equals(name)) {
            conf.extendsFrom(new Configuration[]{config});
        }
    }
}

