/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.gradle.graalvm;

import io.micronaut.gradle.MicronautExtension;
import io.micronaut.gradle.MicronautRuntime;
import io.micronaut.gradle.PluginsHelper;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.graalvm.buildtools.gradle.NativeImagePlugin;
import org.graalvm.buildtools.gradle.dsl.GraalVMExtension;
import org.graalvm.buildtools.gradle.dsl.NativeImageOptions;
import org.graalvm.buildtools.gradle.tasks.BuildNativeImageTask;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.file.RegularFile;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.testing.Test;
import org.gradle.language.jvm.tasks.ProcessResources;
import org.gradle.process.CommandLineArgumentProvider;

public class MicronautGraalPlugin
implements Plugin<Project> {
    public static final String RICH_OUTPUT_PROPERTY = "io.micronaut.graalvm.rich.output";
    private static final Set<String> SOURCE_SETS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("main", "test")));
    private static final List<String> GRAALVM_MODULE_EXPORTS = Collections.unmodifiableList(Arrays.asList("org.graalvm.nativeimage.builder/com.oracle.svm.core.jdk", "org.graalvm.nativeimage.builder/com.oracle.svm.core.configure", "org.graalvm.sdk/org.graalvm.nativeimage.impl"));

    public void apply(Project project) {
        project.getPluginManager().apply(NativeImagePlugin.class);
        this.workaroundForResourcesDirectoryMissing(project);
        project.getPluginManager().withPlugin("io.micronaut.minimal.library", plugin -> {
            MicronautExtension extension = (MicronautExtension)project.getExtensions().findByType(MicronautExtension.class);
            MicronautGraalPlugin.configureAnnotationProcessing(project, extension);
        });
        project.getPluginManager().withPlugin("io.micronaut.minimal.application", plugin -> {
            MicronautExtension extension = (MicronautExtension)project.getExtensions().findByType(MicronautExtension.class);
            MicronautGraalPlugin.configureAnnotationProcessing(project, extension);
        });
        GraalVMExtension graal = (GraalVMExtension)project.getExtensions().findByType(GraalVMExtension.class);
        graal.getBinaries().configureEach(options -> {
            options.resources(rsrc -> rsrc.autodetection(inf -> {
                inf.getEnabled().convention((Object)true);
                inf.getIgnoreExistingResourcesConfigFile().convention((Object)true);
                inf.getRestrictToProjectDependencies().convention((Object)true);
            }));
            options.jvmArgs(MicronautGraalPlugin.getGraalVMBuilderExports());
            Provider richOutput = project.getProviders().systemProperty(RICH_OUTPUT_PROPERTY);
            if (richOutput.isPresent()) {
                options.getRichOutput().convention(richOutput.map(Boolean::parseBoolean));
            }
        });
        project.getPluginManager().withPlugin("application", plugin -> {
            TaskContainer tasks = project.getTasks();
            tasks.withType(BuildNativeImageTask.class).named("nativeCompile", nativeImageTask -> {
                DependencySet implementation;
                boolean isAwsApp;
                MicronautRuntime mr = PluginsHelper.resolveRuntime((Project)project);
                if (mr.isLambdaProvided() && (isAwsApp = (implementation = project.getConfigurations().getByName("implementation").getDependencies()).stream().noneMatch(dependency -> Objects.equals(dependency.getGroup(), "io.micronaut.aws") && dependency.getName().equals("micronaut-function-aws")))) {
                    ((NativeImageOptions)nativeImageTask.getOptions().get()).getMainClass().set((Object)"io.micronaut.function.aws.runtime.MicronautLambdaRuntime");
                }
            });
            HashSet alreadyRegisteredTaskNames = new HashSet();
            project.afterEvaluate(p -> tasks.withType(Test.class).getCollectionSchema().getElements().forEach(element -> {
                String testName = element.getName();
                this.registerTestAgainstNativeImageTask(alreadyRegisteredTaskNames, tasks, testName);
            }));
        });
    }

    private void workaroundForResourcesDirectoryMissing(Project project) {
        project.getPluginManager().withPlugin("java", plugin -> project.afterEvaluate(unused -> project.getTasks().withType(ProcessResources.class).configureEach(task -> {
            File destinationDir = task.getDestinationDir();
            if (destinationDir != null) {
                destinationDir.mkdirs();
            }
        })));
    }

    private void registerTestAgainstNativeImageTask(Set<String> alreadyRegistered, TaskContainer tasks, String testName) {
        if (alreadyRegistered.add(testName)) {
            tasks.register(testName + "NativeImage", Test.class, nativeImageTestTask -> {
                Test testTask = (Test)tasks.getByName(testName);
                nativeImageTestTask.setClasspath(testTask.getClasspath());
                nativeImageTestTask.getJavaLauncher().set((Provider)testTask.getJavaLauncher());
                final BuildNativeImageTask nativeBuild = (BuildNativeImageTask)tasks.findByName("nativeCompile");
                nativeImageTestTask.setForkEvery(Long.valueOf(testTask.getForkEvery()));
                nativeImageTestTask.setTestClassesDirs(testTask.getTestClassesDirs());
                nativeImageTestTask.getJvmArgumentProviders().add(new CommandLineArgumentProvider(){

                    @InputFile
                    @PathSensitive(value=PathSensitivity.RELATIVE)
                    Provider<RegularFile> getInputFile() {
                        return nativeBuild.getOutputFile();
                    }

                    public Iterable<String> asArguments() {
                        return Collections.singleton("-Dmicronaut.test.server.executable=" + ((RegularFile)this.getInputFile().get()).getAsFile().getAbsolutePath());
                    }
                });
                nativeImageTestTask.setDescription("Runs tests against a native image build of the server. Requires the server to allow the port to configurable with 'micronaut.server.port'.");
            });
        }
    }

    private static void configureAnnotationProcessing(Project project, MicronautExtension extension) {
        SourceSetContainer sourceSets = ((JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets();
        project.afterEvaluate(unused -> {
            ListProperty sets = extension.getProcessing().getAdditionalSourceSets();
            if (sets.isPresent()) {
                MicronautGraalPlugin.addGraalVMAnnotationProcessorDependency(project, (Iterable)sets.get());
            }
        });
        MicronautGraalPlugin.addGraalVMAnnotationProcessorDependency(project, sourceSets.stream().filter(sourceSet -> SOURCE_SETS.contains(sourceSet.getName())).collect(Collectors.toList()));
    }

    private static void addGraalVMAnnotationProcessorDependency(Project project, Iterable<SourceSet> sourceSets) {
        for (SourceSet sourceSet : sourceSets) {
            project.getDependencies().add(sourceSet.getAnnotationProcessorConfigurationName(), (Object)"io.micronaut:micronaut-graal");
        }
    }

    public static List<String> getGraalVMBuilderExports() {
        return GRAALVM_MODULE_EXPORTS.stream().map(module -> "--add-exports=" + module + "=ALL-UNNAMED").collect(Collectors.toList());
    }
}

