/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.gradle.docker;

import com.bmuschko.gradle.docker.tasks.image.Dockerfile;
import io.micronaut.gradle.docker.editor.DefaultEditor;
import io.micronaut.gradle.docker.editor.Editor;
import io.micronaut.gradle.docker.editor.FingerprintingEditor;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.file.RegularFile;
import org.gradle.api.model.ObjectFactory;

abstract class DockerfileEditor {
    private DockerfileEditor() {
    }

    static void apply(ObjectFactory objects, Dockerfile task, List<Action<? super Editor>> actions) {
        try {
            Path dockerFile = ((RegularFile)task.getDestFile().get()).getAsFile().toPath();
            List<String> lines = Files.readAllLines(dockerFile);
            DefaultEditor editor = (DefaultEditor)objects.newInstance(DefaultEditor.class, new Object[]{objects, Optional.empty(), lines, Optional.empty(), Optional.empty()});
            actions.forEach(tweak -> tweak.execute((Object)editor));
            Files.write(dockerFile, editor.getLines(), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new GradleException("Unable to edit docker file", (Throwable)e);
        }
    }

    static List<String> fingerprintOf(ObjectFactory objects, List<Action<? super Editor>> actions) {
        FingerprintingEditor editor = (FingerprintingEditor)objects.newInstance(FingerprintingEditor.class, new Object[]{objects, new ArrayList()});
        actions.forEach(tweak -> tweak.execute((Object)editor));
        return editor.getFingerprint();
    }
}

