/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.email.postmark;

import com.postmarkapp.postmark.client.data.model.message.Message;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.email.Attachment;
import io.micronaut.email.BodyType;
import io.micronaut.email.Contact;
import io.micronaut.email.Email;
import io.micronaut.email.EmailComposer;
import io.micronaut.email.EmailException;
import io.micronaut.email.TrackLinks;
import io.micronaut.email.postmark.PostmarkConfiguration;
import jakarta.inject.Singleton;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class PostmarkEmailComposer
implements EmailComposer<Message> {
    private static final Logger LOG = LoggerFactory.getLogger(PostmarkEmailComposer.class);
    private final PostmarkConfiguration postmarkConfiguration;

    public PostmarkEmailComposer(PostmarkConfiguration postmarkConfiguration) {
        this.postmarkConfiguration = postmarkConfiguration;
    }

    @NonNull
    public Message compose(@NonNull @NotNull @Valid Email email) throws EmailException {
        Message message = new Message();
        PostmarkEmailComposer.ifNotNullOrElse(email.getFrom().getName(), name -> message.setFrom(name, email.getFrom().getEmail()), () -> message.setFrom(email.getFrom().getEmail()));
        PostmarkEmailComposer.ifNotNull(email.getTo(), to -> message.setTo(to.stream().map(Contact::getEmail).toList()));
        PostmarkEmailComposer.ifNotNull(email.getCc(), cc -> message.setCc(cc.stream().map(Contact::getEmail).toList()));
        PostmarkEmailComposer.ifNotNull(email.getBcc(), bcc -> message.setBcc(bcc.stream().map(Contact::getEmail).toList()));
        PostmarkEmailComposer.ifNotNull(email.getReplyToCollection(), PostmarkEmailComposer.validateReplyTo().andThen(replyTo -> message.setReplyTo(((Contact)CollectionUtils.last((Collection)replyTo)).getEmail())));
        message.setSubject(email.getSubject());
        PostmarkEmailComposer.ifNotNull(email.getBody(), body -> {
            body.get(BodyType.HTML).ifPresent(arg_0 -> ((Message)message).setHtmlBody(arg_0));
            body.get(BodyType.TEXT).ifPresent(arg_0 -> ((Message)message).setTextBody(arg_0));
        });
        message.setTrackOpens(Boolean.valueOf(this.postmarkConfiguration.getTrackOpens()));
        this.trackLinks(this.postmarkConfiguration.getTrackLinks()).ifPresent(arg_0 -> ((Message)message).setTrackLinks(arg_0));
        PostmarkEmailComposer.ifNotNull(email.getAttachments(), PostmarkEmailComposer.validateAttachments().andThen(list -> list.forEach(att -> message.addAttachment(att.getFilename(), att.getContent(), att.getContentType(), att.getId()))));
        return message;
    }

    @NonNull
    private Optional<Message.TRACK_LINKS> trackLinks(@NonNull TrackLinks trackLinks) {
        switch (trackLinks) {
            case HTML: {
                return Optional.of(Message.TRACK_LINKS.Html);
            }
            case TEXT: {
                return Optional.of(Message.TRACK_LINKS.Text);
            }
            case HTML_AND_TEXT: {
                return Optional.of(Message.TRACK_LINKS.HtmlAndText);
            }
        }
        return Optional.empty();
    }

    private static Consumer<Collection<Contact>> validateReplyTo() {
        return replyTo -> {
            if (replyTo.size() > 1 && LOG.isWarnEnabled()) {
                LOG.warn("Postmark does not support multiple 'replyTo' addresses (Email has {} replyTo addresses)", (Object)replyTo.size());
            }
        };
    }

    private static Consumer<List<Attachment>> validateAttachments() {
        return attachments -> {
            if (LOG.isWarnEnabled()) {
                attachments.stream().filter(att -> "inline".equals(att.getDisposition()) && att.getId() == null).findAny().ifPresent(x -> LOG.warn("Content ID is required for Postmark inlined attachments"));
            }
        };
    }

    private static <T> void ifNotNull(T value, Consumer<T> action) {
        Optional.ofNullable(value).ifPresent(action);
    }

    private static <T> void ifNotNullOrElse(T value, Consumer<T> action, Runnable emptyAction) {
        Optional.ofNullable(value).ifPresentOrElse(action, emptyAction);
    }
}

