/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.email.postmark;

import com.postmarkapp.postmark.Postmark;
import com.postmarkapp.postmark.client.ApiClient;
import com.postmarkapp.postmark.client.data.model.message.Message;
import com.postmarkapp.postmark.client.data.model.message.MessageResponse;
import com.postmarkapp.postmark.client.exception.PostmarkException;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.email.AbstractTransactionalEmailSender;
import io.micronaut.email.Email;
import io.micronaut.email.EmailException;
import io.micronaut.email.postmark.PostmarkConfiguration;
import io.micronaut.email.postmark.PostmarkEmailComposer;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="postmark")
@Requires(beans={PostmarkConfiguration.class, PostmarkEmailComposer.class})
@Singleton
public class PostmarkEmailSender
extends AbstractTransactionalEmailSender<Message, MessageResponse> {
    public static final String NAME = "postmark";
    private static final Logger LOG = LoggerFactory.getLogger(PostmarkEmailSender.class);
    private final ApiClient client;
    private final PostmarkEmailComposer postmarkEmailComposer;

    public PostmarkEmailSender(@Named(value="io") ExecutorService executorService, PostmarkConfiguration postmarkConfiguration, PostmarkEmailComposer postmarkEmailComposer) {
        super(executorService);
        this.client = Postmark.getApiClient((String)postmarkConfiguration.getApiToken());
        this.postmarkEmailComposer = postmarkEmailComposer;
    }

    @NonNull
    public String getName() {
        return NAME;
    }

    @NonNull
    public MessageResponse send(@NonNull @NotNull @Valid Email email, @NonNull @NotNull Consumer<Message> emailRequest) throws EmailException {
        Message message = (Message)this.postmarkEmailComposer.compose(email, emailRequest);
        try {
            MessageResponse response = this.client.deliverMessage(message);
            if (LOG.isTraceEnabled()) {
                LOG.trace("postmark errorCode: {}", (Object)("" + response.getErrorCode()));
                LOG.trace("postmark response: {}", (Object)response.getMessage());
            }
            return response;
        }
        catch (PostmarkException | IOException e) {
            throw new EmailException(e);
        }
    }
}

