/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.email.postmark;

import com.postmarkapp.postmark.client.data.model.message.Message;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.email.Attachment;
import io.micronaut.email.Body;
import io.micronaut.email.BodyType;
import io.micronaut.email.Contact;
import io.micronaut.email.Email;
import io.micronaut.email.EmailComposer;
import io.micronaut.email.EmailException;
import io.micronaut.email.TrackLinks;
import io.micronaut.email.postmark.PostmarkConfiguration;
import jakarta.inject.Singleton;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.Optional;
import java.util.stream.Collectors;

@Singleton
public class PostmarkEmailComposer
implements EmailComposer<Message> {
    private final PostmarkConfiguration postmarkConfiguration;

    public PostmarkEmailComposer(PostmarkConfiguration postmarkConfiguration) {
        this.postmarkConfiguration = postmarkConfiguration;
    }

    @NonNull
    public Message compose(@NonNull @NotNull @Valid Email email) throws EmailException {
        Message message = new Message();
        if (email.getFrom().getName() != null) {
            message.setFrom(email.getFrom().getName(), email.getFrom().getEmail());
        } else {
            message.setFrom(email.getFrom().getEmail());
        }
        if (email.getTo() != null) {
            message.setTo(email.getTo().stream().map(Contact::getEmail).collect(Collectors.toList()));
        }
        message.setSubject(email.getSubject());
        Body body = email.getBody();
        if (body != null) {
            body.get(BodyType.HTML).ifPresent(arg_0 -> ((Message)message).setHtmlBody(arg_0));
            body.get(BodyType.TEXT).ifPresent(arg_0 -> ((Message)message).setTextBody(arg_0));
        }
        message.setTrackOpens(Boolean.valueOf(this.postmarkConfiguration.getTrackOpens()));
        this.trackLinks(this.postmarkConfiguration.getTrackLinks()).ifPresent(arg_0 -> ((Message)message).setTrackLinks(arg_0));
        if (email.getAttachments() != null) {
            for (Attachment att : email.getAttachments()) {
                message.addAttachment(att.getFilename(), att.getContent(), att.getContentType(), att.getId());
            }
        }
        return message;
    }

    @NonNull
    private Optional<Message.TRACK_LINKS> trackLinks(@NonNull TrackLinks trackLinks) {
        switch (trackLinks) {
            case HTML: {
                return Optional.of(Message.TRACK_LINKS.Html);
            }
            case TEXT: {
                return Optional.of(Message.TRACK_LINKS.Text);
            }
            case HTML_AND_TEXT: {
                return Optional.of(Message.TRACK_LINKS.HtmlAndText);
            }
        }
        return Optional.empty();
    }
}

