/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.transaction.async;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.async.propagation.ReactorPropagation;
import io.micronaut.core.propagation.PropagatedContext;
import io.micronaut.transaction.TransactionDefinition;
import io.micronaut.transaction.async.AsyncTransactionOperations;
import io.micronaut.transaction.async.AsyncTransactionStatus;
import io.micronaut.transaction.reactive.ReactiveTransactionStatus;
import io.micronaut.transaction.reactive.ReactorReactiveTransactionOperations;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Mono;
import reactor.util.context.Context;
import reactor.util.context.ContextView;

@Internal
public final class AsyncUsingReactiveTransactionOperations<C>
implements AsyncTransactionOperations<C> {
    private final ReactorReactiveTransactionOperations<C> reactiveTransactionOperations;

    public AsyncUsingReactiveTransactionOperations(ReactorReactiveTransactionOperations<C> reactiveTransactionOperations) {
        this.reactiveTransactionOperations = reactiveTransactionOperations;
    }

    @Override
    public Optional<? extends DefaultAsyncTransactionStatus<?>> findTransactionStatus() {
        return Optional.ofNullable(this.reactiveTransactionOperations.getTransactionStatus((ContextView)ReactorPropagation.addPropagatedContext((Context)Context.empty(), (PropagatedContext)PropagatedContext.getOrEmpty()))).map(DefaultAsyncTransactionStatus::new);
    }

    @Override
    public <T> CompletionStage<T> withTransaction(TransactionDefinition definition, Function<AsyncTransactionStatus<C>, CompletionStage<T>> handler) {
        Mono result = Mono.fromDirect(this.reactiveTransactionOperations.withTransaction(definition, (ReactiveTransactionStatus<C> status) -> Mono.deferContextual(contextView -> Mono.fromCompletionStage(() -> {
            try (PropagatedContext.Scope ignore = ReactorPropagation.findPropagatedContext((ContextView)contextView).orElseGet(PropagatedContext::getOrEmpty).propagate();){
                CompletionStage completionStage = (CompletionStage)handler.apply(new DefaultAsyncTransactionStatus(status));
                return completionStage;
            }
        }))));
        return AsyncUsingReactiveTransactionOperations.onCompleteCompleteFuture(result);
    }

    private static <T> CompletableFuture<T> onCompleteCompleteFuture(Publisher<T> publisher) {
        final PropagatedContext propagatedContext = PropagatedContext.getOrEmpty();
        final CompletableFuture completableFuture = new CompletableFuture();
        publisher.subscribe((Subscriber)new CoreSubscriber<T>(){
            private T result;

            @NonNull
            public Context currentContext() {
                return ReactorPropagation.addPropagatedContext((Context)Context.empty(), (PropagatedContext)propagatedContext);
            }

            public void onSubscribe(Subscription s) {
                s.request(1L);
            }

            public void onNext(T t) {
                this.result = t;
            }

            public void onError(Throwable t) {
                try (PropagatedContext.Scope ignore = propagatedContext.propagate();){
                    completableFuture.completeExceptionally(t);
                }
            }

            public void onComplete() {
                try (PropagatedContext.Scope ignore = propagatedContext.propagate();){
                    completableFuture.complete(this.result);
                }
            }
        });
        return completableFuture;
    }

    private record DefaultAsyncTransactionStatus<T>(ReactiveTransactionStatus<T> status) implements AsyncTransactionStatus<T>
    {
        @Override
        public boolean isNewTransaction() {
            return this.status.isNewTransaction();
        }

        @Override
        public void setRollbackOnly() {
            this.status.setRollbackOnly();
        }

        @Override
        public boolean isRollbackOnly() {
            return this.status.isRollbackOnly();
        }

        @Override
        public boolean isCompleted() {
            return this.status.isCompleted();
        }

        @Override
        public TransactionDefinition getTransactionDefinition() {
            return this.status.getTransactionDefinition();
        }

        @Override
        @NonNull
        public T getConnection() {
            return this.status.getConnection();
        }
    }
}

