/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.transaction.support;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import java.util.function.Function;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.CorePublisher;
import reactor.core.CoreSubscriber;
import reactor.util.context.Context;

@Internal
final class SyncCompleteAndErrorPublisher<T>
implements CorePublisher<T> {
    private final CorePublisher<T> actualPublisher;
    private final Supplier<Publisher<Void>> onComplete;
    private final Function<Throwable, Publisher<Void>> onThrowable;
    private final boolean isMono;

    SyncCompleteAndErrorPublisher(CorePublisher<T> actualPublisher, Supplier<Publisher<Void>> onComplete, Function<Throwable, Publisher<Void>> onThrowable, boolean isMono) {
        this.actualPublisher = actualPublisher;
        this.onComplete = onComplete;
        this.onThrowable = onThrowable;
        this.isMono = isMono;
    }

    public void subscribe(CoreSubscriber<? super T> actualSubscriber) {
        this.doSubscribe((Subscriber<? super T>)actualSubscriber, actualSubscriber);
    }

    public void subscribe(Subscriber<? super T> actualSubscriber) {
        if (actualSubscriber instanceof CoreSubscriber) {
            CoreSubscriber coreSubscriber = (CoreSubscriber)actualSubscriber;
            this.doSubscribe(actualSubscriber, coreSubscriber);
        } else {
            this.doSubscribe(actualSubscriber, null);
        }
    }

    private void doSubscribe(final Subscriber<? super T> actualSubscriber, final @Nullable CoreSubscriber<? super T> coreSubscriber) {
        this.actualPublisher.subscribe(new CoreSubscriber<T>(){
            Subscription actualSubscription;

            public Context currentContext() {
                if (coreSubscriber == null) {
                    return Context.empty();
                }
                return coreSubscriber.currentContext();
            }

            public void onSubscribe(Subscription s) {
                this.actualSubscription = s;
                actualSubscriber.onSubscribe(s);
            }

            public void onNext(final T t) {
                if (SyncCompleteAndErrorPublisher.this.isMono) {
                    this.actualSubscription.cancel();
                    SyncCompleteAndErrorPublisher.this.onComplete.get().subscribe((Subscriber)new Subscriber<Void>(){

                        public void onSubscribe(Subscription s) {
                            s.request(1L);
                        }

                        public void onNext(Void unused) {
                        }

                        public void onError(Throwable t2) {
                            actualSubscriber.onError(t2);
                        }

                        public void onComplete() {
                            actualSubscriber.onNext(t);
                            actualSubscriber.onComplete();
                        }
                    });
                } else {
                    actualSubscriber.onNext(t);
                }
            }

            public void onError(final Throwable throwable) {
                SyncCompleteAndErrorPublisher.this.onThrowable.apply(throwable).subscribe((Subscriber)new Subscriber<Void>(){

                    public void onSubscribe(Subscription s) {
                        s.request(1L);
                    }

                    public void onNext(Void unused) {
                    }

                    public void onError(Throwable t) {
                        actualSubscriber.onError(t);
                    }

                    public void onComplete() {
                        actualSubscriber.onError(throwable);
                    }
                });
            }

            public void onComplete() {
                SyncCompleteAndErrorPublisher.this.onComplete.get().subscribe((Subscriber)new Subscriber<Void>(){

                    public void onSubscribe(Subscription s) {
                        s.request(1L);
                    }

                    public void onNext(Void unused) {
                    }

                    public void onError(Throwable t) {
                        actualSubscriber.onError(t);
                    }

                    public void onComplete() {
                        actualSubscriber.onComplete();
                    }
                });
            }
        });
    }
}

