/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.transaction.test;

import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Property;
import io.micronaut.context.annotation.Replaces;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.spring.tx.test.SpringTransactionTestExecutionListener;
import io.micronaut.test.annotation.TransactionMode;
import io.micronaut.test.context.TestContext;
import io.micronaut.test.context.TestExecutionListener;
import io.micronaut.test.context.TestMethodInterceptor;
import io.micronaut.test.context.TestMethodInvocationContext;
import io.micronaut.transaction.SynchronousTransactionManager;
import io.micronaut.transaction.TransactionDefinition;
import io.micronaut.transaction.TransactionOperations;
import io.micronaut.transaction.TransactionStatus;
import io.micronaut.transaction.support.ExceptionUtil;
import io.micronaut.transaction.sync.SynchronousTransactionOperationsFromReactiveTransactionOperations;
import java.util.concurrent.atomic.AtomicInteger;

@EachBean(value=TransactionOperations.class)
@Requirements(value={@Requires(classes={TestExecutionListener.class}), @Requires(property="micronaut.test.transactional", value="true", defaultValue="true")})
@Replaces(value=SpringTransactionTestExecutionListener.class)
@Internal
public class DefaultTestTransactionExecutionListener
implements TestExecutionListener,
TestMethodInterceptor<Object> {
    @Nullable
    private final SynchronousTransactionManager<Object> synchronousTransactionManager;
    private final TransactionOperations<Object> transactionManager;
    private final TransactionMode transactionMode;
    private TransactionStatus<Object> tx;
    private final AtomicInteger counter = new AtomicInteger();
    private final AtomicInteger setupCounter = new AtomicInteger();
    private final boolean rollback;

    protected DefaultTestTransactionExecutionListener(TransactionOperations<Object> transactionManager, @Property(name="micronaut.test.rollback", defaultValue="true") boolean rollback, @Property(name="micronaut.test.transaction-mode", defaultValue="SEPARATE_TRANSACTIONS") TransactionMode transactionMode) {
        SynchronousTransactionManager<Object> syncTx;
        this.transactionManager = transactionManager;
        SynchronousTransactionManager<Object> synchronousTransactionManager = this.synchronousTransactionManager = transactionManager instanceof SynchronousTransactionManager ? (syncTx = (SynchronousTransactionManager<Object>)transactionManager) : null;
        if (transactionMode == TransactionMode.SINGLE_TRANSACTION && transactionManager instanceof SynchronousTransactionOperationsFromReactiveTransactionOperations) {
            throw new IllegalStateException("Transaction mode SINGLE_TRANSACTION is not supported when the transaction manager doesn't support detached transaction!");
        }
        this.rollback = rollback;
        this.transactionMode = transactionMode;
    }

    public Object interceptTest(TestMethodInvocationContext<Object> methodInvocationContext) throws Throwable {
        if (this.transactionMode == TransactionMode.SINGLE_TRANSACTION) {
            return super.interceptTest(methodInvocationContext);
        }
        TestContext testContext = methodInvocationContext.getTestContext();
        if (!testContext.isSupportsTestMethodInterceptors()) {
            throw new IllegalStateException("Test method interceptor was marked as not supported!");
        }
        try {
            return this.transactionManager.execute(TransactionDefinition.named(testContext.getTestName()), status -> {
                try {
                    Object object = super.interceptTest(methodInvocationContext);
                    return object;
                }
                catch (Throwable e) {
                    throw new UncheckedException(e);
                }
                finally {
                    if (this.rollback) {
                        status.setRollbackOnly();
                    }
                }
            });
        }
        catch (UncheckedException e) {
            return ExceptionUtil.sneakyThrow(e.getCause());
        }
    }

    public Object interceptBeforeEach(TestMethodInvocationContext<Object> methodInvocationContext) throws Throwable {
        if (this.transactionMode == TransactionMode.SINGLE_TRANSACTION) {
            return super.interceptBeforeEach(methodInvocationContext);
        }
        TestContext testContext = methodInvocationContext.getTestContext();
        if (!testContext.isSupportsTestMethodInterceptors()) {
            throw new IllegalStateException("Test method interceptor was marked as not supported!");
        }
        try {
            return this.transactionManager.execute(TransactionDefinition.named(testContext.getTestName()), status -> {
                try {
                    return super.interceptBeforeEach(methodInvocationContext);
                }
                catch (Throwable e) {
                    throw new UncheckedException(e);
                }
            });
        }
        catch (UncheckedException e) {
            return ExceptionUtil.sneakyThrow(e.getCause());
        }
    }

    public Object interceptAfterEach(TestMethodInvocationContext<Object> methodInvocationContext) throws Throwable {
        if (this.transactionMode == TransactionMode.SINGLE_TRANSACTION) {
            return super.interceptAfterEach(methodInvocationContext);
        }
        TestContext testContext = methodInvocationContext.getTestContext();
        if (!testContext.isSupportsTestMethodInterceptors()) {
            throw new IllegalStateException("Test method interceptor was marked as not supported!");
        }
        try {
            return this.transactionManager.execute(TransactionDefinition.named(testContext.getTestName()), status -> {
                try {
                    return super.interceptAfterEach(methodInvocationContext);
                }
                catch (Throwable e) {
                    throw new UncheckedException(e);
                }
            });
        }
        catch (UncheckedException e) {
            return ExceptionUtil.sneakyThrow(e.getCause());
        }
    }

    public void beforeSetupTest(TestContext testContext) {
        this.beforeTestExecution(testContext);
    }

    public void afterSetupTest(TestContext testContext) {
        if (this.transactionMode.equals((Object)TransactionMode.SINGLE_TRANSACTION)) {
            this.setupCounter.getAndIncrement();
        } else {
            this.afterTestExecution(testContext, false);
        }
    }

    public void beforeCleanupTest(TestContext testContext) {
        this.beforeTestExecution(testContext);
    }

    public void afterCleanupTest(TestContext testContext) {
        this.afterTestExecution(testContext, false);
    }

    public void afterTestExecution(TestContext testContext) {
        if (this.transactionMode == TransactionMode.SINGLE_TRANSACTION) {
            this.counter.addAndGet(-this.setupCounter.getAndSet(0));
        }
        this.afterTestExecution(testContext, this.rollback);
    }

    public void beforeTestExecution(TestContext testContext) {
        if (this.counter.getAndIncrement() == 0) {
            if (this.transactionMode == TransactionMode.SEPARATE_TRANSACTIONS && testContext.isSupportsTestMethodInterceptors()) {
                return;
            }
            if (this.synchronousTransactionManager == null) {
                throw new IllegalStateException("Transaction manager doesn't support detached transaction and the testing framework doesn't support intercepting the test invocation!");
            }
            this.tx = this.synchronousTransactionManager.getTransaction(TransactionDefinition.named(testContext.getTestName()));
        }
    }

    private void afterTestExecution(TestContext testContext, boolean rollback) {
        if (this.counter.decrementAndGet() == 0) {
            if (this.transactionMode == TransactionMode.SEPARATE_TRANSACTIONS && testContext.isSupportsTestMethodInterceptors()) {
                return;
            }
            if (this.synchronousTransactionManager == null) {
                return;
            }
            if (rollback) {
                this.synchronousTransactionManager.rollback(this.tx);
            } else {
                this.synchronousTransactionManager.commit(this.tx);
            }
        }
    }

    private static class UncheckedException
    extends RuntimeException {
        UncheckedException(Throwable e) {
            super(e);
        }
    }
}

