/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.transaction.impl;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.data.connection.ConnectionStatus;
import io.micronaut.transaction.TransactionDefinition;
import io.micronaut.transaction.impl.AbstractInternalTransaction;
import io.micronaut.transaction.impl.InternalTransaction;
import io.micronaut.transaction.support.TransactionSynchronization;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Internal
public abstract class DefaultTransactionStatus<C>
extends AbstractInternalTransaction<C>
implements InternalTransaction<C> {
    protected final ConnectionStatus<C> connectionStatus;
    private final TransactionDefinition definition;
    @Nullable
    private Object transaction;
    @Nullable
    private Object savepoint;

    private DefaultTransactionStatus(ConnectionStatus<C> connectionStatus, TransactionDefinition definition) {
        this.connectionStatus = connectionStatus;
        this.definition = definition;
    }

    public static <C> DefaultTransactionStatus<C> newTx(ConnectionStatus<C> connectionStatus, TransactionDefinition definition) {
        return new NewTransactionStatus<C>(connectionStatus, definition);
    }

    public static <C> DefaultTransactionStatus<C> noTx(ConnectionStatus<C> connectionStatus, TransactionDefinition definition) {
        return new NoTxTransactionStatus<C>(connectionStatus, definition);
    }

    public static <C> DefaultTransactionStatus<C> existingTx(ConnectionStatus<C> connectionStatus, DefaultTransactionStatus<C> existingTransaction) {
        return new ExistingTransactionStatus<C>(connectionStatus, existingTransaction);
    }

    @Override
    public boolean isNestedTransaction() {
        return this.definition.getPropagationBehavior() == TransactionDefinition.Propagation.NESTED;
    }

    public void setTransaction(Object transaction) {
        this.transaction = transaction;
    }

    public void setSavepoint(@NonNull Object savepoint) {
        this.savepoint = savepoint;
    }

    @Nullable
    public Object getSavepoint() {
        return this.savepoint;
    }

    @Override
    @Nullable
    public Object getTransaction() {
        return this.transaction;
    }

    @Override
    @NonNull
    public C getConnection() {
        return (C)this.connectionStatus.getConnection();
    }

    @Override
    public ConnectionStatus<C> getConnectionStatus() {
        return this.connectionStatus;
    }

    @Override
    public TransactionDefinition getTransactionDefinition() {
        return this.definition;
    }

    public String toString() {
        return "DefaultTransactionStatus{connectionStatus=" + String.valueOf(this.connectionStatus) + ", definition=" + String.valueOf(this.definition) + ", transaction=" + String.valueOf(this.transaction) + ", savepoint=" + String.valueOf(this.savepoint) + ", synchronizations=" + String.valueOf(this.synchronizations) + "}";
    }

    private static final class NewTransactionStatus<C>
    extends DefaultTransactionStatus<C> {
        public NewTransactionStatus(ConnectionStatus<C> connectionStatus, TransactionDefinition definition) {
            super(connectionStatus, definition);
        }

        @Override
        public boolean isNewTransaction() {
            return true;
        }

        @Override
        public String toString() {
            return "NewTransactionStatus{transaction=" + String.valueOf(this.getTransaction()) + ", connectionStatus=" + String.valueOf(this.connectionStatus) + ", definition=" + String.valueOf(this.getTransactionDefinition()) + ", savepoint=" + String.valueOf(this.getSavepoint()) + ", synchronizations=" + String.valueOf(this.synchronizations) + "}";
        }
    }

    private static final class NoTxTransactionStatus<C>
    extends DefaultTransactionStatus<C> {
        public NoTxTransactionStatus(ConnectionStatus<C> connectionStatus, TransactionDefinition definition) {
            super(connectionStatus, definition);
        }

        @Override
        public boolean isNewTransaction() {
            return false;
        }

        @Override
        public String toString() {
            return "NoTxTransactionStatus{}";
        }
    }

    private static final class ExistingTransactionStatus<C>
    extends DefaultTransactionStatus<C> {
        private final DefaultTransactionStatus<C> existingTransaction;

        public ExistingTransactionStatus(ConnectionStatus<C> connectionStatus, DefaultTransactionStatus<C> existingTransaction) {
            super(connectionStatus, existingTransaction.getTransactionDefinition());
            this.existingTransaction = existingTransaction;
        }

        @Override
        public boolean isNewTransaction() {
            return false;
        }

        @Override
        public void setRollbackOnly() {
            super.setRollbackOnly();
            this.existingTransaction.setGlobalRollbackOnly();
        }

        @Override
        public void registerSynchronization(TransactionSynchronization synchronization) {
            this.existingTransaction.registerSynchronization(synchronization);
        }

        @Override
        public String toString() {
            return "ExistingTransactionStatus{existingTransaction=" + String.valueOf(this.existingTransaction) + "}";
        }
    }
}

