/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.transaction.impl;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.data.connection.ConnectionStatus;
import io.micronaut.transaction.TransactionDefinition;
import io.micronaut.transaction.impl.AbstractInternalTransaction;
import io.micronaut.transaction.impl.InternalTransaction;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Internal
public abstract class DefaultTransactionStatus<C>
extends AbstractInternalTransaction<C>
implements InternalTransaction<C> {
    protected final ConnectionStatus<C> connectionStatus;
    private final TransactionDefinition definition;
    @Nullable
    private Object transaction;

    private DefaultTransactionStatus(ConnectionStatus<C> connectionStatus, TransactionDefinition definition) {
        this.connectionStatus = connectionStatus;
        this.definition = definition;
    }

    public static <C> DefaultTransactionStatus<C> newTx(ConnectionStatus<C> connectionStatus, TransactionDefinition definition) {
        return new NewTransactionStatus<C>(connectionStatus, definition);
    }

    public static <C> DefaultTransactionStatus<C> noTx(ConnectionStatus<C> connectionStatus, TransactionDefinition definition) {
        return new NoTxTransactionStatus<C>(connectionStatus, definition);
    }

    public static <C> DefaultTransactionStatus<C> existingTx(ConnectionStatus<C> connectionStatus, DefaultTransactionStatus<C> existingTransaction) {
        return new ExistingTransactionStatus<C>(connectionStatus, existingTransaction);
    }

    public void setTransaction(Object transaction) {
        this.transaction = transaction;
    }

    @Override
    @Nullable
    public Object getTransaction() {
        return this.transaction;
    }

    @Override
    @NonNull
    public C getConnection() {
        return (C)this.connectionStatus.getConnection();
    }

    @Override
    public ConnectionStatus<C> getConnectionStatus() {
        return this.connectionStatus;
    }

    @Override
    public TransactionDefinition getTransactionDefinition() {
        return this.definition;
    }

    private static final class NewTransactionStatus<C>
    extends DefaultTransactionStatus<C> {
        public NewTransactionStatus(ConnectionStatus<C> connectionStatus, TransactionDefinition definition) {
            super(connectionStatus, definition);
        }

        @Override
        public boolean isNewTransaction() {
            return true;
        }
    }

    private static final class NoTxTransactionStatus<C>
    extends DefaultTransactionStatus<C> {
        public NoTxTransactionStatus(ConnectionStatus<C> connectionStatus, TransactionDefinition definition) {
            super(connectionStatus, definition);
        }

        @Override
        public boolean isNewTransaction() {
            return false;
        }
    }

    private static final class ExistingTransactionStatus<C>
    extends DefaultTransactionStatus<C> {
        private final DefaultTransactionStatus<C> existingTransaction;

        public ExistingTransactionStatus(ConnectionStatus<C> connectionStatus, DefaultTransactionStatus<C> existingTransaction) {
            super(connectionStatus, existingTransaction.getTransactionDefinition());
            this.existingTransaction = existingTransaction;
        }

        @Override
        public boolean isNewTransaction() {
            return false;
        }

        @Override
        public void setRollbackOnly() {
            super.setRollbackOnly();
            this.existingTransaction.setGlobalRollbackOnly();
        }
    }
}

