/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.transaction.interceptor;

import io.micronaut.aop.InterceptedMethod;
import io.micronaut.aop.kotlin.KotlinInterceptedMethod;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.transaction.interceptor.CoroutineTxHelper;
import io.micronaut.transaction.support.TransactionSynchronizationManager;
import jakarta.inject.Singleton;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;

@Internal
@Singleton
public final class TxCompletionStageDataIntroductionHelper {
    private final CoroutineTxHelper coroutineTxHelper;

    public TxCompletionStageDataIntroductionHelper(@Nullable CoroutineTxHelper coroutineTxHelper) {
        this.coroutineTxHelper = coroutineTxHelper;
    }

    public CompletionStage<Object> decorate(InterceptedMethod interceptedMethod, Supplier<CompletionStage<Object>> supplier) {
        TransactionSynchronizationManager.TransactionSynchronizationState state = null;
        if (interceptedMethod instanceof KotlinInterceptedMethod) {
            KotlinInterceptedMethod kotlinInterceptedMethod = (KotlinInterceptedMethod)interceptedMethod;
            state = Objects.requireNonNull(this.coroutineTxHelper).getTxState(kotlinInterceptedMethod);
        }
        return TransactionSynchronizationManager.decorateCompletionStage(state, supplier);
    }
}

