/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.transaction.interceptor;

import io.micronaut.aop.InterceptPhase;
import io.micronaut.aop.InterceptedMethod;
import io.micronaut.aop.MethodInterceptor;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.aop.kotlin.KotlinInterceptedMethod;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.transaction.SynchronousTransactionManager;
import io.micronaut.transaction.TransactionDefinition;
import io.micronaut.transaction.TransactionOperations;
import io.micronaut.transaction.TransactionOperationsRegistry;
import io.micronaut.transaction.TransactionStatus;
import io.micronaut.transaction.annotation.TransactionalAdvice;
import io.micronaut.transaction.async.AsyncTransactionOperations;
import io.micronaut.transaction.exceptions.NoTransactionException;
import io.micronaut.transaction.interceptor.KotlinInterceptedMethodAsyncResultSupplier;
import io.micronaut.transaction.interceptor.TransactionDataSourceTenantResolver;
import io.micronaut.transaction.reactive.ReactiveTransactionOperations;
import io.micronaut.transaction.support.TransactionUtil;
import jakarta.inject.Singleton;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import org.reactivestreams.Publisher;

@Singleton
@Internal
public final class TransactionalInterceptor
implements MethodInterceptor<Object, Object> {
    private static final ThreadLocal<TransactionInfo> TRANSACTION_INFO_HOLDER = new ThreadLocal<TransactionInfo>(){

        public String toString() {
            return "Current aspect-driven transaction";
        }
    };
    private final Map<TenantExecutableMethod, TransactionInvocation> transactionInvocationMap = new ConcurrentHashMap<TenantExecutableMethod, TransactionInvocation>(30);
    @NonNull
    private final TransactionOperationsRegistry transactionOperationsRegistry;
    @Nullable
    private final TransactionDataSourceTenantResolver tenantResolver;

    public TransactionalInterceptor(@NonNull TransactionOperationsRegistry transactionOperationsRegistry, @Nullable TransactionDataSourceTenantResolver tenantResolver) {
        this.transactionOperationsRegistry = transactionOperationsRegistry;
        this.tenantResolver = tenantResolver;
    }

    public int getOrder() {
        return InterceptPhase.TRANSACTION.getPosition();
    }

    public Object intercept(MethodInvocationContext<Object, Object> context) {
        String tenantDataSourceName = this.tenantResolver != null ? this.tenantResolver.resolveTenantDataSourceName() : null;
        InterceptedMethod interceptedMethod = InterceptedMethod.of(context);
        try {
            ExecutableMethod executableMethod = context.getExecutableMethod();
            TransactionInvocation transactionInvocation = this.transactionInvocationMap.computeIfAbsent(new TenantExecutableMethod(tenantDataSourceName, executableMethod), ignore -> {
                String dataSource = tenantDataSourceName == null ? (String)executableMethod.stringValue(TransactionalAdvice.class).orElse(null) : tenantDataSourceName;
                TransactionDefinition transactionDefinition = this.resolveTransactionDefinition((ExecutableMethod<Object, Object>)executableMethod);
                switch (interceptedMethod.resultType()) {
                    case PUBLISHER: {
                        ReactiveTransactionOperations reactiveTransactionOperations = this.transactionOperationsRegistry.provideReactive(ReactiveTransactionOperations.class, dataSource);
                        return new TransactionInvocation(null, reactiveTransactionOperations, null, transactionDefinition);
                    }
                    case COMPLETION_STAGE: {
                        AsyncTransactionOperations asyncTransactionOperations = this.transactionOperationsRegistry.provideAsync(AsyncTransactionOperations.class, dataSource);
                        return new TransactionInvocation(null, null, asyncTransactionOperations, transactionDefinition);
                    }
                }
                SynchronousTransactionManager transactionManager = this.transactionOperationsRegistry.provideSynchronous(SynchronousTransactionManager.class, dataSource);
                return new TransactionInvocation(transactionManager, null, null, transactionDefinition);
            });
            TransactionDefinition definition = transactionInvocation.definition;
            switch (interceptedMethod.resultType()) {
                case PUBLISHER: {
                    ReactiveTransactionOperations reactiveTransactionOperations = Objects.requireNonNull(transactionInvocation.reactiveTransactionOperations);
                    return interceptedMethod.handleResult(reactiveTransactionOperations.withTransaction(definition, status -> {
                        context.setAttribute((CharSequence)"io.micronaut.tx.STATUS", (Object)status);
                        context.setAttribute((CharSequence)"io.micronaut.tx.ATTRIBUTE", (Object)definition);
                        return (Publisher)Publishers.convertPublisher((Object)context.proceed(), Publisher.class);
                    }));
                }
                case COMPLETION_STAGE: {
                    CompletionStage result;
                    AsyncTransactionOperations asyncTransactionOperations = Objects.requireNonNull(transactionInvocation.asyncTransactionOperations);
                    boolean isKotlinSuspended = interceptedMethod instanceof KotlinInterceptedMethod;
                    if (isKotlinSuspended) {
                        KotlinInterceptedMethod kotlinInterceptedMethod = (KotlinInterceptedMethod)interceptedMethod;
                        result = asyncTransactionOperations.withTransaction(definition, new KotlinInterceptedMethodAsyncResultSupplier(kotlinInterceptedMethod));
                    } else {
                        result = asyncTransactionOperations.withTransaction(definition, status -> interceptedMethod.interceptResultAsCompletionStage());
                    }
                    return interceptedMethod.handleResult(result);
                }
                case SYNCHRONOUS: {
                    TransactionOperations transactionManager = Objects.requireNonNull(transactionInvocation.transactionManager);
                    return transactionManager.execute(definition, status -> {
                        TransactionInfo prev = TRANSACTION_INFO_HOLDER.get();
                        try {
                            TransactionInfo transactionInfo = new TransactionInfo(definition, status);
                            TRANSACTION_INFO_HOLDER.set(transactionInfo);
                            Object object = context.proceed();
                            return object;
                        }
                        finally {
                            if (prev == null) {
                                TRANSACTION_INFO_HOLDER.remove();
                            } else {
                                TRANSACTION_INFO_HOLDER.set(prev);
                            }
                        }
                    });
                }
            }
            return interceptedMethod.unsupported();
        }
        catch (Exception e) {
            return interceptedMethod.handleException(e);
        }
    }

    public static <T> TransactionStatus<T> currentTransactionStatus() throws NoTransactionException {
        TransactionInfo info = TRANSACTION_INFO_HOLDER.get();
        if (info == null) {
            throw new NoTransactionException("No transaction aspect-managed TransactionStatus in scope");
        }
        return info.transactionStatus;
    }

    private TransactionDefinition resolveTransactionDefinition(ExecutableMethod<Object, Object> executableMethod) {
        TransactionDefinition definition = TransactionUtil.getTransactionDefinition(executableMethod.getDeclaringType().getSimpleName() + "." + executableMethod.getMethodName(), executableMethod);
        if (definition == TransactionDefinition.DEFAULT) {
            throw new IllegalStateException("No declared @Transactional annotation present");
        }
        return definition;
    }

    private static final class TenantExecutableMethod {
        private final String dataSource;
        private final ExecutableMethod method;
        private final int hashCode;

        TenantExecutableMethod(String dataSource, ExecutableMethod method) {
            this.dataSource = dataSource;
            this.method = method;
            this.hashCode = Objects.hash(dataSource, method);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TenantExecutableMethod that = (TenantExecutableMethod)o;
            return Objects.equals(this.dataSource, that.dataSource) && this.method.equals(that.method);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    private static final class TransactionInfo<T> {
        private final TransactionDefinition transactionDefinition;
        private final TransactionStatus<T> transactionStatus;

        private TransactionInfo(TransactionDefinition transactionDefinition, TransactionStatus<T> transactionStatus) {
            this.transactionDefinition = transactionDefinition;
            this.transactionStatus = transactionStatus;
        }
    }

    private static final class TransactionInvocation<C> {
        @Nullable
        final TransactionOperations<C> transactionManager;
        @Nullable
        final ReactiveTransactionOperations<C> reactiveTransactionOperations;
        @Nullable
        final AsyncTransactionOperations<C> asyncTransactionOperations;
        final TransactionDefinition definition;

        TransactionInvocation(@Nullable TransactionOperations<C> transactionManager, @Nullable ReactiveTransactionOperations<C> reactiveTransactionOperations, @Nullable AsyncTransactionOperations<C> asyncTransactionOperations, TransactionDefinition definition) {
            this.transactionManager = transactionManager;
            this.reactiveTransactionOperations = reactiveTransactionOperations;
            this.asyncTransactionOperations = asyncTransactionOperations;
            this.definition = definition;
        }
    }
}

