/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.transaction.test;

import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Property;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.test.context.TestExecutionListener;
import io.micronaut.test.context.TestMethodInterceptor;
import io.micronaut.test.context.TestMethodInvocationContext;
import io.micronaut.transaction.SynchronousTransactionManager;
import io.micronaut.transaction.TransactionDefinition;
import io.micronaut.transaction.support.ExceptionUtil;
import io.micronaut.transaction.test.SpockMethodTransactionDefinitionProvider;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Optional;

@EachBean(value=SynchronousTransactionManager.class)
@Requirements(value={@Requires(classes={TestExecutionListener.class}), @Requires(property="micronaut.test.transactional", value="true", defaultValue="true")})
@Internal
public final class DefaultTestTransactionMethodInterceptor<T>
implements TestMethodInterceptor<T> {
    private final SynchronousTransactionManager<T> transactionManager;
    private final boolean rollback;
    private final SpockMethodTransactionDefinitionProvider spockMethodTransactionDefinitionProvider;

    DefaultTestTransactionMethodInterceptor(SynchronousTransactionManager<T> transactionManager, @Property(name="micronaut.test.rollback", defaultValue="true") boolean rollback, Optional<SpockMethodTransactionDefinitionProvider> spockProvider) {
        this.transactionManager = transactionManager;
        this.rollback = rollback;
        this.spockMethodTransactionDefinitionProvider = spockProvider.orElse(null);
    }

    public T interceptBeforeEach(TestMethodInvocationContext<T> context) {
        return this.execute(context, false);
    }

    public T interceptTest(TestMethodInvocationContext<T> context) {
        return this.execute(context, this.rollback);
    }

    public T interceptAfterEach(TestMethodInvocationContext<T> context) {
        return this.execute(context, false);
    }

    private T execute(TestMethodInvocationContext<T> context, boolean rollbackAfter) {
        TransactionDefinition definition;
        AnnotatedElement annotatedElement = context.getTestContext().getTestMethod();
        if (this.spockMethodTransactionDefinitionProvider != null) {
            definition = this.spockMethodTransactionDefinitionProvider.provide(annotatedElement);
        } else if (annotatedElement instanceof Method) {
            Method method = (Method)annotatedElement;
            String name = method.getDeclaringClass().getSimpleName() + "." + method.getName();
            definition = TransactionDefinition.named(name);
        } else {
            definition = TransactionDefinition.DEFAULT;
        }
        return (T)this.transactionManager.execute(definition, status -> {
            try {
                Object proceed = context.proceed();
                if (rollbackAfter) {
                    status.setRollbackOnly();
                }
                return proceed;
            }
            catch (Throwable e) {
                return ExceptionUtil.sneakyThrow(e);
            }
        });
    }
}

